"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSpanLinks = void 0;
var _create_call_apm_api = require("./create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSpanLinks = ({
  traceId,
  docId,
  start,
  end,
  processorEvent
}, signal) => (0, _create_call_apm_api.callApmApi)('GET /internal/apm/traces/{traceId}/span_links/{spanId}', {
  params: {
    path: {
      traceId,
      spanId: docId
    },
    query: {
      kuery: '',
      start,
      end,
      processorEvent
    }
  },
  signal
});
exports.fetchSpanLinks = fetchSpanLinks;