"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchErrorsByTraceId = void 0;
var _create_call_apm_api = require("./create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchErrorsByTraceId = ({
  traceId,
  docId,
  start,
  end
}, signal) => (0, _create_call_apm_api.callApmApi)('GET /internal/apm/unified_traces/{traceId}/errors', {
  params: {
    path: {
      traceId
    },
    query: {
      docId,
      start,
      end
    }
  },
  signal
});
exports.fetchErrorsByTraceId = fetchErrorsByTraceId;