"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.traceUnprocessedOtelSample = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const traceUnprocessedOtelSample = exports.traceUnprocessedOtelSample = [{
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxuxV1',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.652Z',
    attributes: {
      'code.filepath': '/var/www/vendor/slim/slim/Slim/App.php',
      'code.function': 'handle',
      'code.lineno': 207,
      'code.namespace': 'SlimApp',
      'http.request.body.size': '20',
      'http.request.method': 'POST',
      'http.response.body.size': '',
      'http.response.status_code': 200,
      'http.route': '/getquote',
      'network.protocol.version': '1.1',
      'server.address': 'quote',
      'server.port': 8090,
      'url.full': 'http://quote:8090/getquote',
      'url.path': '/getquote',
      'url.scheme': 'http',
      'user_agent.original': ''
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 3677750,
    kind: 'Server',
    links: [],
    name: 'POST /getquote',
    parent_span_id: 'd2efb76164a77608',
    resource: {
      attributes: {
        'container.id': '3fc5289d71e63dee4531ec6eec45eda797ca94fca8095243a30b99c011f61184',
        'host.arch': 'aarch64',
        'host.name': '3fc5289d71e6',
        'os.description': '6.10.14-linuxkit',
        'os.name': 'Linux',
        'os.type': 'linux',
        'os.version': '#1 SMP Tue Apr 15 16:00:54 UTC 2025',
        'process.command': 'public/index.php',
        'process.command_args': ['public/index.php'],
        'process.executable.path': '/usr/local/bin/php',
        'process.owner': 'www-data',
        'process.pid': 1,
        'process.runtime.name': 'cli',
        'process.runtime.version': '8.3.21',
        'service.name': 'quote',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.distro.name': 'opentelemetry-php-instrumentation',
        'telemetry.distro.version': '1.1.3',
        'telemetry.sdk.language': 'php',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.2.2'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.32.0'
    },
    scope: {
      name: 'io.opentelemetry.contrib.php.slim',
      schema_url: 'https://opentelemetry.io/schemas/1.25.0'
    },
    span_id: 'cdd3568d81149715',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV179WB',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.663Z',
    attributes: {
      'app.order.amount': 2973,
      'app.order.id': '662a6820-3674-11f0-a2f8-e20e5be2e054',
      'app.order.items.count': 1,
      'app.shipping.amount': 874,
      'app.shipping.tracking.id': '74f26702-d59f-4ee3-994f-19099fade416',
      'app.user.currency': 'USD',
      'app.user.id': '66268e16-3674-11f0-afe6-c26f282a82c9',
      'net.sock.peer.addr': '172.20.0.24',
      'net.sock.peer.port': 60980,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'PlaceOrder',
      'rpc.service': 'oteldemo.CheckoutService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 229049792,
    kind: 'Server',
    links: [],
    name: 'oteldemo.CheckoutService/PlaceOrder',
    parent_span_id: '1e91b6d0dbd2caa3',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: 'f56a077af7b355cd',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV14aA7',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.733Z',
    attributes: {
      'app.payment.amount': '2973.50',
      'rpc.grpc.status_code': 0,
      'rpc.method': 'Charge',
      'rpc.service': 'oteldemo.PaymentService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 27292875,
    kind: 'Server',
    links: [],
    name: 'grpc.oteldemo.PaymentService/Charge',
    parent_span_id: '591e9ba68ed54ab2',
    resource: {
      attributes: {
        'container.id': '94686b321e77e2c4ee423c385728b67faed36831a4da60e055fc29052fece965',
        'host.arch': 'arm64',
        'host.name': '94686b321e77',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/usr/src/app/index.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './opentelemetry.js', '/usr/src/app/index.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'node',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'payment',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: '@opentelemetry/instrumentation-grpc',
      version: '0.57.1'
    },
    span_id: 'e95d1217d39d4b9f',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV16b8_',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.668Z',
    attributes: {
      'app.currency.conversion.from': 'USD',
      'app.currency.conversion.to': 'USD',
      'rpc.grpc.status_code': 0,
      'rpc.method': 'Convert',
      'rpc.service': 'oteldemo.CurrencyService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 894958,
    kind: 'Server',
    links: [],
    name: 'Currency/Convert',
    parent_span_id: '8ebad46fe358d61b',
    resource: {
      attributes: {
        'service.name': 'currency',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'cpp',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.20.0'
      }
    },
    scope: {
      name: 'currency'
    },
    span_id: 'e50f640fbb18b7a3',
    status: {
      code: 'Ok'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxv0qj',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.776Z',
    attributes: {
      'app.shipping.tracking.id': '74f26702-d59f-4ee3-994f-19099fade416',
      'rpc.grpc.status_code': 0,
      'rpc.method': 'ShipOrder',
      'rpc.service': 'oteldemo.ShippingService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 44583,
    kind: 'Server',
    links: [],
    name: 'oteldemo.ShippingService/ShipOrder',
    parent_span_id: '220635f3eab3ce55',
    resource: {
      attributes: {
        'os.type': 'linux',
        'process.command_args': ['/app/shipping'],
        'process.pid': 1,
        'service.name': 'shipping',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'rust',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '0.22.1'
      }
    },
    scope: {
      name: 'shipping'
    },
    span_id: 'dbafa1e7835034aa',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxx04t',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.654Z',
    attributes: {
      'app.quote.cost.total': 874,
      'app.quote.items.count': 10
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 521459,
    kind: 'Internal',
    links: [],
    name: 'calculate-quote',
    parent_span_id: '5f4f77f336af6748',
    resource: {
      attributes: {
        'container.id': '3fc5289d71e63dee4531ec6eec45eda797ca94fca8095243a30b99c011f61184',
        'host.arch': 'aarch64',
        'host.name': '3fc5289d71e6',
        'os.description': '6.10.14-linuxkit',
        'os.name': 'Linux',
        'os.type': 'linux',
        'os.version': '#1 SMP Tue Apr 15 16:00:54 UTC 2025',
        'process.command': 'public/index.php',
        'process.command_args': ['public/index.php'],
        'process.executable.path': '/usr/local/bin/php',
        'process.owner': 'www-data',
        'process.pid': 1,
        'process.runtime.name': 'cli',
        'process.runtime.version': '8.3.21',
        'service.name': 'quote',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.distro.name': 'opentelemetry-php-instrumentation',
        'telemetry.distro.version': '1.1.3',
        'telemetry.sdk.language': 'php',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.2.2'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.32.0'
    },
    scope: {
      name: 'manual-instrumentation'
    },
    span_id: '51952d3c6ec92b3f',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxyE4L',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.664Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.11',
      'net.sock.peer.port': 7070,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetCart',
      'rpc.service': 'oteldemo.CartService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 1188209,
    kind: 'Client',
    links: [],
    name: 'oteldemo.CartService/GetCart',
    parent_span_id: '2ac80b91c07577a7',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: 'fcb40d60be4649e8',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV16sCd',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.775Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.13',
      'net.sock.peer.port': 50050,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'ShipOrder',
      'rpc.service': 'oteldemo.ShippingService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 2499875,
    kind: 'Client',
    links: [],
    name: 'oteldemo.ShippingService/ShipOrder',
    parent_span_id: 'f56a077af7b355cd',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: '220635f3eab3ce55',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx1FEm',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.794Z',
    attributes: {
      'net.peer.name': '172.20.0.11',
      'net.peer.port': 41192,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'ResolveBoolean',
      'rpc.service': 'flagd.evaluation.v1.Service',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 865209,
    kind: 'Server',
    links: [],
    name: 'flagd.evaluation.v1.Service/ResolveBoolean',
    parent_span_id: '0eb2a6bc38bc1528',
    resource: {
      attributes: {
        'host.name': '495c6da10a50',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 495c6da10a50 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.runtime.version': 'go1.24.1',
        'service.name': 'flagd',
        'service.namespace': 'opentelemetry-demo',
        'service.version': 'v0.12.3',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'connectrpc.com/otelconnect',
      version: 'semver:0.6.0-dev'
    },
    span_id: 'c3b2107659f2bc11',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxw0u7',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.665Z',
    attributes: {
      'app.cart.items.count': 10,
      'app.user.id': '66268e16-3674-11f0-afe6-c26f282a82c9',
      'grpc.method': '/oteldemo.CartService/GetCart',
      'grpc.status_code': '0',
      'http.request.method': 'POST',
      'http.response.status_code': 200,
      'http.route': '/oteldemo.CartService/GetCart',
      'network.protocol.version': '2',
      'server.address': 'cart',
      'server.port': 7070,
      'url.path': '/oteldemo.CartService/GetCart',
      'url.scheme': 'http',
      'user_agent.original': 'grpc-go/1.71.0'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 276500,
    kind: 'Server',
    links: [],
    name: 'POST /oteldemo.CartService/GetCart',
    parent_span_id: 'fcb40d60be4649e8',
    resource: {
      attributes: {
        'container.id': '9bb3d2889b423fdc1776e1124a7f0220adc8f1aae84beed2ee2c28ba7d64489c',
        'host.name': '9bb3d2889b42',
        'service.name': 'cart',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'dotnet',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.11.2'
      }
    },
    scope: {
      name: 'Microsoft.AspNetCore'
    },
    span_id: 'b768cc461df31f91',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxx046',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.779Z',
    attributes: {
      'app.user.id': '66268e16-3674-11f0-afe6-c26f282a82c9',
      'feature_flag.key': 'cartFailure',
      'feature_flag.provider_name': 'flagd Provider',
      'feature_flag.variant': 'off',
      'grpc.method': '/oteldemo.CartService/EmptyCart',
      'grpc.status_code': '0',
      'http.request.method': 'POST',
      'http.response.status_code': 200,
      'http.route': '/oteldemo.CartService/EmptyCart',
      'network.protocol.version': '2',
      'server.address': 'cart',
      'server.port': 7070,
      'url.path': '/oteldemo.CartService/EmptyCart',
      'url.scheme': 'http',
      'user_agent.original': 'grpc-go/1.71.0'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 27135800,
    kind: 'Server',
    links: [],
    name: 'POST /oteldemo.CartService/EmptyCart',
    parent_span_id: '4a19e0fbfef0cd8b',
    resource: {
      attributes: {
        'container.id': '9bb3d2889b423fdc1776e1124a7f0220adc8f1aae84beed2ee2c28ba7d64489c',
        'host.name': '9bb3d2889b42',
        'service.name': 'cart',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'dotnet',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.11.2'
      }
    },
    scope: {
      name: 'Microsoft.AspNetCore'
    },
    span_id: 'cdb431d0e11e3822',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx0FC5',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.661Z',
    attributes: {
      'net.peer.name': 'checkout',
      'net.peer.port': 5050,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'PlaceOrder',
      'rpc.service': 'oteldemo.CheckoutService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 234124000,
    kind: 'Client',
    links: [],
    name: 'grpc.oteldemo.CheckoutService/PlaceOrder',
    parent_span_id: 'e2565c0494aa0322',
    resource: {
      attributes: {
        'container.id': 'af5168d115067dde7668626637de5cfe454fbf4f2c610b2b709b6b378f60624a',
        'host.arch': 'arm64',
        'host.name': 'af5168d11506',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/app/server.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './Instrumentation.js', '/app/server.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'nextjs',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'frontend',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: '@opentelemetry/instrumentation-grpc',
      version: '0.57.1'
    },
    span_id: '1e91b6d0dbd2caa3',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzVDp',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.896Z',
    attributes: {
      'net.peer.name': 'product-catalog',
      'net.peer.port': 3550,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetProduct',
      'rpc.service': 'oteldemo.ProductCatalogService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 10247958,
    kind: 'Client',
    links: [],
    name: 'grpc.oteldemo.ProductCatalogService/GetProduct',
    parent_span_id: 'e2565c0494aa0322',
    resource: {
      attributes: {
        'container.id': 'af5168d115067dde7668626637de5cfe454fbf4f2c610b2b709b6b378f60624a',
        'host.arch': 'arm64',
        'host.name': 'af5168d11506',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/app/server.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './Instrumentation.js', '/app/server.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'nextjs',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'frontend',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: '@opentelemetry/instrumentation-grpc',
      version: '0.57.1'
    },
    span_id: 'e05a164a1590b45c',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV16sCc',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.670Z',
    attributes: {
      busy_ns: 728500,
      'code.filepath': '/usr/local/cargo/registry/src/index.crates.io-6f17d22bba15001f/reqwest-tracing-0.4.8/src/reqwest_otel_span_builder.rs',
      'code.lineno': 138,
      'code.namespace': 'reqwest_tracing::reqwest_otel_span_builder',
      'http.host': 'quote',
      'http.method': 'POST',
      'http.scheme': 'http',
      'http.status_code': '200',
      'http.url': 'http://quote:8090/getquote',
      'http.user_agent': '',
      idle_ns: 16903125,
      'net.host.port': 8090,
      'thread.id': 13,
      'thread.name': 'tokio-runtime-worker'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 17625833,
    kind: 'Client',
    links: [],
    name: 'POST',
    parent_span_id: '3a9dc674aa6f10de',
    resource: {
      attributes: {
        'os.type': 'linux',
        'process.command_args': ['/app/shipping'],
        'process.pid': 1,
        'service.name': 'shipping',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'rust',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '0.22.1'
      }
    },
    scope: {
      name: 'opentelemetry-otlp',
      schema_url: 'https://opentelemetry.io/schemas/1.21.0',
      version: '0.15.0'
    },
    span_id: 'd2efb76164a77608',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx1FEc',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.653Z',
    attributes: {
      'code.filepath': '/var/www/vendor/php-di/slim-bridge/src/ControllerInvoker.php',
      'code.function': '__invoke',
      'code.lineno': 29,
      'code.namespace': 'DIBridgeSlimControllerInvoker'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 1939125,
    kind: 'Internal',
    links: [],
    name: '{closure}',
    parent_span_id: 'cdd3568d81149715',
    resource: {
      attributes: {
        'container.id': '3fc5289d71e63dee4531ec6eec45eda797ca94fca8095243a30b99c011f61184',
        'host.arch': 'aarch64',
        'host.name': '3fc5289d71e6',
        'os.description': '6.10.14-linuxkit',
        'os.name': 'Linux',
        'os.type': 'linux',
        'os.version': '#1 SMP Tue Apr 15 16:00:54 UTC 2025',
        'process.command': 'public/index.php',
        'process.command_args': ['public/index.php'],
        'process.executable.path': '/usr/local/bin/php',
        'process.owner': 'www-data',
        'process.pid': 1,
        'process.runtime.name': 'cli',
        'process.runtime.version': '8.3.21',
        'service.name': 'quote',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.distro.name': 'opentelemetry-php-instrumentation',
        'telemetry.distro.version': '1.1.3',
        'telemetry.sdk.language': 'php',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.2.2'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.32.0'
    },
    scope: {
      name: 'io.opentelemetry.contrib.php.slim',
      schema_url: 'https://opentelemetry.io/schemas/1.25.0'
    },
    span_id: '5f4f77f336af6748',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx1VEQ',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.664Z',
    attributes: {
      'app.cart.items.count': 10,
      'app.order.items.count': 1,
      'app.shipping.amount': 874
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 27452125,
    kind: 'Internal',
    links: [],
    name: 'prepareOrderItemsAndShippingQuoteFromCart',
    parent_span_id: 'f56a077af7b355cd',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'checkout'
    },
    span_id: '2ac80b91c07577a7',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV13JIv',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.863Z',
    attributes: {
      'sinatra.template_name': 'layout'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 3794166,
    kind: 'Internal',
    links: [],
    name: 'sinatra.render_template',
    parent_span_id: '0617e63bb0dd5a7a',
    resource: {
      attributes: {
        'process.command': 'email_server.rb',
        'process.pid': 1,
        'process.runtime.description': 'ruby 3.2.2 (2023-03-30 revision e51014f9c0) [aarch64-linux]',
        'process.runtime.name': 'ruby',
        'process.runtime.version': '3.2.2',
        'service.name': 'email',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'ruby',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.4.1'
      }
    },
    scope: {
      name: 'OpenTelemetry::Instrumentation::Sinatra',
      version: '0.23.5'
    },
    span_id: '64208202996736ff',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx0FCi',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.667Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.12',
      'net.sock.peer.port': 7001,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'Convert',
      'rpc.service': 'oteldemo.CurrencyService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 2530500,
    kind: 'Client',
    links: [],
    name: 'oteldemo.CurrencyService/Convert',
    parent_span_id: '2ac80b91c07577a7',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: '8ebad46fe358d61b',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV15r0S',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.669Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.13',
      'net.sock.peer.port': 50050,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetQuote',
      'rpc.service': 'oteldemo.ShippingService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 20268000,
    kind: 'Client',
    links: [],
    name: 'oteldemo.ShippingService/GetQuote',
    parent_span_id: '2ac80b91c07577a7',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: '1eede05ef1ac23ab',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxw0vw',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.778Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.11',
      'net.sock.peer.port': 7070,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'EmptyCart',
      'rpc.service': 'oteldemo.CartService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 30355458,
    kind: 'Client',
    links: [],
    name: 'oteldemo.CartService/EmptyCart',
    parent_span_id: 'f56a077af7b355cd',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: '4a19e0fbfef0cd8b',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx1VES',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.809Z',
    attributes: {
      'http.method': 'POST',
      'http.request_content_length': 479,
      'http.status_code': '200',
      'http.url': 'http://email:6060/send_order_confirmation',
      'net.peer.name': 'email',
      'net.peer.port': 6060
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 82411000,
    kind: 'Client',
    links: [],
    name: 'HTTP POST',
    parent_span_id: 'f56a077af7b355cd',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/net/http/otelhttp',
      version: '0.60.0'
    },
    span_id: '82b77baa952e7120',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx1VER',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.892Z',
    attributes: {
      'messaging.destination.name': 'orders',
      'messaging.kafka.destination.partition': 0,
      'messaging.kafka.message.offset': 0,
      'messaging.kafka.producer.duration_ms': 0,
      'messaging.kafka.producer.success': true,
      'messaging.operation': 'publish',
      'messaging.system': 'kafka',
      'network.transport': 'tcp',
      'peer.service': 'kafka'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 537958,
    kind: 'Producer',
    links: [],
    name: 'orders publish',
    parent_span_id: 'f56a077af7b355cd',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'checkout'
    },
    span_id: '625aa8e149049389',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxuxV7',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.795Z',
    attributes: {
      'feature_flag.key': 'cartFailure',
      'feature_flag.provider_name': 'flagd',
      'feature_flag.variant': 'off'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 422292,
    kind: 'Server',
    links: [],
    name: 'resolveBoolean',
    parent_span_id: 'c3b2107659f2bc11',
    resource: {
      attributes: {
        'host.name': '495c6da10a50',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 495c6da10a50 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.runtime.version': 'go1.24.1',
        'service.name': 'flagd',
        'service.namespace': 'opentelemetry-demo',
        'service.version': 'v0.12.3',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'flagd.evaluation.v1'
    },
    span_id: '482bcc40c13778e8',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV15r0Y',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.749Z',
    attributes: {
      'app.loyalty.level': 'bronze',
      'app.payment.card_type': 'visa',
      'app.payment.card_valid': true,
      'app.payment.charged': false
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 13687750,
    kind: 'Internal',
    links: [],
    name: 'charge',
    parent_span_id: 'e95d1217d39d4b9f',
    resource: {
      attributes: {
        'container.id': '94686b321e77e2c4ee423c385728b67faed36831a4da60e055fc29052fece965',
        'host.arch': 'arm64',
        'host.name': '94686b321e77',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/usr/src/app/index.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './opentelemetry.js', '/usr/src/app/index.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'node',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'payment',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: 'payment'
    },
    span_id: '736a5e93e04eb481',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV15b3H',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.787Z',
    attributes: {
      'rpc.grpc.status_code': 0,
      'rpc.method': 'ResolveBoolean',
      'rpc.service': 'flagd.evaluation.v1.Service',
      'rpc.system': 'grpc',
      'server.address': 'flagd',
      'server.port': 8013
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 13640500,
    kind: 'Client',
    links: [],
    name: 'flagd.evaluation.v1.Service/ResolveBoolean',
    parent_span_id: 'cdb431d0e11e3822',
    resource: {
      attributes: {
        'container.id': '9bb3d2889b423fdc1776e1124a7f0220adc8f1aae84beed2ee2c28ba7d64489c',
        'host.name': '9bb3d2889b42',
        'service.name': 'cart',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'dotnet',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.11.2'
      }
    },
    scope: {
      name: 'OpenTelemetry.Instrumentation.GrpcNetClient',
      version: '1.11.0-beta.2'
    },
    span_id: 'e8d932b3aa684a94',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzVCH',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.789Z',
    attributes: {
      'http.request.method': 'POST',
      'http.response.status_code': 200,
      'network.protocol.version': '2',
      'server.address': 'flagd',
      'server.port': 8013,
      'url.full': 'http://flagd:8013/flagd.evaluation.v1.Service/ResolveBoolean'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 9849800,
    kind: 'Client',
    links: [],
    name: 'POST',
    parent_span_id: 'e8d932b3aa684a94',
    resource: {
      attributes: {
        'container.id': '9bb3d2889b423fdc1776e1124a7f0220adc8f1aae84beed2ee2c28ba7d64489c',
        'host.name': '9bb3d2889b42',
        'service.name': 'cart',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'dotnet',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.11.2'
      }
    },
    scope: {
      name: 'System.Net.Http'
    },
    span_id: '0eb2a6bc38bc1528',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxw0vB',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.660Z',
    attributes: {
      'http.flavor': '1.1',
      'http.host': 'frontend-proxy:8080',
      'http.method': 'POST',
      'http.request_content_length_uncompressed': 404,
      'http.scheme': 'http',
      'http.status_code': '200',
      'http.status_text': 'OK',
      'http.target': '/api/checkout',
      'http.url': 'http://frontend-proxy:8080/api/checkout',
      'http.user_agent': 'python-requests/2.32.3',
      'net.host.ip': '172.20.0.24',
      'net.host.name': 'frontend-proxy',
      'net.host.port': 8080,
      'net.peer.ip': '172.20.0.26',
      'net.peer.port': 34716,
      'net.transport': 'ip_tcp'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 246517583,
    kind: 'Server',
    links: [],
    name: 'POST',
    parent_span_id: '99e36adf40935241',
    resource: {
      attributes: {
        'container.id': 'af5168d115067dde7668626637de5cfe454fbf4f2c610b2b709b6b378f60624a',
        'host.arch': 'arm64',
        'host.name': 'af5168d11506',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/app/server.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './Instrumentation.js', '/app/server.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'nextjs',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'frontend',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: '@opentelemetry/instrumentation-http',
      version: '0.57.1'
    },
    span_id: '25e7916c0b0ecced',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxv0oJ',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.660Z',
    attributes: {
      component: 'proxy',
      'http.protocol': 'HTTP/1.1',
      'http.status_code': '200',
      'peer.address': '172.20.0.24:8080',
      response_flags: '-',
      upstream_address: '172.20.0.24:8080',
      upstream_cluster: 'frontend',
      'upstream_cluster.name': 'frontend'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 246771000,
    kind: 'Client',
    links: [],
    name: 'router frontend egress',
    parent_span_id: '67341493f035bbbd',
    resource: {
      attributes: {
        'service.name': 'frontend-proxy',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2'
      }
    },
    span_id: '99e36adf40935241',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxv0oK',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.660Z',
    attributes: {
      component: 'proxy',
      downstream_cluster: '-',
      'guid:x-request-id': 'd0090436-cd80-9c41-b384-d56728333e05',
      'http.method': 'POST',
      'http.protocol': 'HTTP/1.1',
      'http.status_code': '200',
      'http.url': 'http://frontend-proxy:8080/api/checkout',
      node_id: '',
      'peer.address': '172.20.0.25',
      request_size: '404',
      response_flags: '-',
      response_size: '1003',
      upstream_cluster: 'frontend',
      'upstream_cluster.name': 'frontend',
      user_agent: 'python-requests/2.32.3',
      zone: ''
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 247630000,
    kind: 'Server',
    links: [],
    name: 'ingress',
    parent_span_id: '6f66a81b37c22083',
    resource: {
      attributes: {
        'service.name': 'frontend-proxy',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2'
      }
    },
    span_id: '67341493f035bbbd',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV13JKQ',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.660Z',
    attributes: {
      'http.method': 'POST',
      'http.status_code': '200',
      'http.url': 'http://frontend-proxy:8080/api/checkout'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 249305792,
    kind: 'Client',
    links: [],
    name: 'POST',
    resource: {
      attributes: {
        'service.name': 'load-generator',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'python',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.0'
      }
    },
    scope: {
      name: 'opentelemetry.instrumentation.requests',
      version: '0.51b0'
    },
    span_id: '6f66a81b37c22083',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV15b35',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.861Z',
    attributes: {
      'app.email.recipient': 'larry_sergei@example.com'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 28460667,
    kind: 'Internal',
    links: [],
    name: 'send_email',
    parent_span_id: 'b0fc6eb249ecfa06',
    resource: {
      attributes: {
        'process.command': 'email_server.rb',
        'process.pid': 1,
        'process.runtime.description': 'ruby 3.2.2 (2023-03-30 revision e51014f9c0) [aarch64-linux]',
        'process.runtime.name': 'ruby',
        'process.runtime.version': '3.2.2',
        'service.name': 'email',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'ruby',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.4.1'
      }
    },
    scope: {
      name: 'email'
    },
    span_id: 'e5ce8a3b70153009',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV13JKP',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.666Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.18',
      'net.sock.peer.port': 3550,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetProduct',
      'rpc.service': 'oteldemo.ProductCatalogService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 801416,
    kind: 'Client',
    links: [],
    name: 'oteldemo.ProductCatalogService/GetProduct',
    parent_span_id: '2ac80b91c07577a7',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: 'cd8cdedec29aa0e4',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxuxXw',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.689Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.12',
      'net.sock.peer.port': 7001,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'Convert',
      'rpc.service': 'oteldemo.CurrencyService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 2136459,
    kind: 'Client',
    links: [],
    name: 'oteldemo.CurrencyService/Convert',
    parent_span_id: '2ac80b91c07577a7',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: '2d15293f7e09fe4d',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx0VA-',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.692Z',
    attributes: {
      'net.sock.peer.addr': '172.20.0.15',
      'net.sock.peer.port': 50051,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'Charge',
      'rpc.service': 'oteldemo.PaymentService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 82159542,
    kind: 'Client',
    links: [],
    name: 'oteldemo.PaymentService/Charge',
    parent_span_id: 'f56a077af7b355cd',
    resource: {
      attributes: {
        'host.name': '4137be727f41',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 4137be727f41 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./checkout'],
        'process.executable.name': 'checkout',
        'process.executable.path': '/usr/src/app/checkout',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'checkout',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: '591e9ba68ed54ab2',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzVB7',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.795Z',
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 73542,
    kind: 'Internal',
    links: [],
    name: 'resolveBoolean',
    parent_span_id: '482bcc40c13778e8',
    resource: {
      attributes: {
        'host.name': '495c6da10a50',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 495c6da10a50 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.runtime.version': 'go1.24.1',
        'service.name': 'flagd',
        'service.namespace': 'opentelemetry-demo',
        'service.version': 'v0.12.3',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'jsonEvaluator'
    },
    span_id: '780a5994c400d831',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV179U8',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.666Z',
    attributes: {
      'app.product.id': '2ZYFJ3GM2N',
      'app.product.name': 'Roof Binoculars',
      'net.sock.peer.addr': '172.20.0.23',
      'net.sock.peer.port': 43354,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetProduct',
      'rpc.service': 'oteldemo.ProductCatalogService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 68000,
    kind: 'Server',
    links: [],
    name: 'oteldemo.ProductCatalogService/GetProduct',
    parent_span_id: 'cd8cdedec29aa0e4',
    resource: {
      attributes: {
        'host.name': '810476db2456',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 810476db2456 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./product-catalog'],
        'process.executable.name': 'product-catalog',
        'process.executable.path': '/usr/src/app/product-catalog',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'product-catalog',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: 'f20eb79c52a23c82',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzVB_',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.898Z',
    attributes: {
      'app.product.id': '2ZYFJ3GM2N',
      'app.product.name': 'Roof Binoculars',
      'net.sock.peer.addr': '172.20.0.24',
      'net.sock.peer.port': 39474,
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetProduct',
      'rpc.service': 'oteldemo.ProductCatalogService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 6640000,
    kind: 'Server',
    links: [],
    name: 'oteldemo.ProductCatalogService/GetProduct',
    parent_span_id: 'e05a164a1590b45c',
    resource: {
      attributes: {
        'host.name': '810476db2456',
        'os.description': 'Debian GNU/Linux Debian GNU/Linux 12 (bookworm) (Linux 810476db2456 6.10.14-linuxkit #1 SMP Tue Apr 15 16:00:54 UTC 2025 aarch64)',
        'os.type': 'linux',
        'process.command_args': ['./product-catalog'],
        'process.executable.name': 'product-catalog',
        'process.executable.path': '/usr/src/app/product-catalog',
        'process.owner': 'nonroot',
        'process.pid': 1,
        'process.runtime.description': 'go version go1.24.3 linux/arm64',
        'process.runtime.name': 'go',
        'process.runtime.version': 'go1.24.3',
        'service.name': 'product-catalog',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'go',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.35.0'
      },
      schema_url: 'https://opentelemetry.io/schemas/1.26.0'
    },
    scope: {
      name: 'go.opentelemetry.io/contrib/instrumentation/google.golang.org/grpc/otelgrpc',
      version: '0.60.0'
    },
    span_id: 'd7ddfbb25b5d7635',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzlCX',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.661Z',
    attributes: {
      'http.status_code': '200',
      'next.span_name': 'executing api route (pages) /api/checkout',
      'next.span_type': 'Node.runHandler'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 245744250,
    kind: 'Internal',
    links: [],
    name: 'executing api route (pages) /api/checkout',
    parent_span_id: '0789fc52e7cbb9d6',
    resource: {
      attributes: {
        'container.id': 'af5168d115067dde7668626637de5cfe454fbf4f2c610b2b709b6b378f60624a',
        'host.arch': 'arm64',
        'host.name': 'af5168d11506',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/app/server.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './Instrumentation.js', '/app/server.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'nextjs',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'frontend',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: 'next.js',
      version: '0.0.1'
    },
    span_id: 'e2565c0494aa0322',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzlCZ',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.661Z',
    attributes: {
      'http.method': 'POST',
      'http.status_code': '200',
      'http.target': '/api/checkout',
      'next.rsc': false,
      'next.span_name': 'POST /api/checkout',
      'next.span_type': 'BaseServer.handleRequest'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 246262375,
    kind: 'Server',
    links: [],
    name: 'POST /api/checkout',
    parent_span_id: '25e7916c0b0ecced',
    resource: {
      attributes: {
        'container.id': 'af5168d115067dde7668626637de5cfe454fbf4f2c610b2b709b6b378f60624a',
        'host.arch': 'arm64',
        'host.name': 'af5168d11506',
        'os.type': 'linux',
        'os.version': '6.10.14-linuxkit',
        'process.command': '/app/server.js',
        'process.command_args': ['/usr/local/bin/node', '--require', './Instrumentation.js', '/app/server.js'],
        'process.executable.name': 'node',
        'process.executable.path': '/usr/local/bin/node',
        'process.owner': 'nextjs',
        'process.pid': 17,
        'process.runtime.description': 'Node.js',
        'process.runtime.name': 'nodejs',
        'process.runtime.version': '22.15.1',
        'service.name': 'frontend',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'nodejs',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.30.1'
      }
    },
    scope: {
      name: 'next.js',
      version: '0.0.1'
    },
    span_id: '0789fc52e7cbb9d6',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx0VA9',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.670Z',
    attributes: {
      'app.shipping.cost.total': '874.0',
      'app.shipping.items.count': 10,
      'app.shipping.zip_code': '94043',
      'rpc.grpc.status_code': 0,
      'rpc.method': 'GetQuote',
      'rpc.service': 'oteldemo.ShippingService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 18143291,
    kind: 'Server',
    links: [],
    name: 'oteldemo.ShippingService/GetQuote',
    parent_span_id: '1eede05ef1ac23ab',
    resource: {
      attributes: {
        'os.type': 'linux',
        'process.command_args': ['/app/shipping'],
        'process.pid': 1,
        'service.name': 'shipping',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'rust',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '0.22.1'
      }
    },
    scope: {
      name: 'shipping'
    },
    span_id: '3a9dc674aa6f10de',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVxzVBx',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.690Z',
    attributes: {
      'app.currency.conversion.from': 'USD',
      'app.currency.conversion.to': 'USD',
      'rpc.grpc.status_code': 0,
      'rpc.method': 'Convert',
      'rpc.service': 'oteldemo.CurrencyService',
      'rpc.system': 'grpc'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 733792,
    kind: 'Server',
    links: [],
    name: 'Currency/Convert',
    parent_span_id: '2d15293f7e09fe4d',
    resource: {
      attributes: {
        'service.name': 'currency',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'cpp',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.20.0'
      }
    },
    scope: {
      name: 'currency'
    },
    span_id: '23d22912809c6ba5',
    status: {
      code: 'Ok'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcVx0FDR',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.840Z',
    attributes: {
      'app.order.id': '662a6820-3674-11f0-a2f8-e20e5be2e054',
      'http.host': 'email:6060',
      'http.method': 'POST',
      'http.route': '/send_order_confirmation',
      'http.scheme': 'http',
      'http.status_code': '200',
      'http.target': '/send_order_confirmation',
      'http.user_agent': 'Go-http-client/1.1'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 50425042,
    kind: 'Server',
    links: [],
    name: 'POST /send_order_confirmation',
    parent_span_id: '82b77baa952e7120',
    resource: {
      attributes: {
        'process.command': 'email_server.rb',
        'process.pid': 1,
        'process.runtime.description': 'ruby 3.2.2 (2023-03-30 revision e51014f9c0) [aarch64-linux]',
        'process.runtime.name': 'ruby',
        'process.runtime.version': '3.2.2',
        'service.name': 'email',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'ruby',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.4.1'
      }
    },
    scope: {
      name: 'OpenTelemetry::Instrumentation::Rack',
      version: '0.24.6'
    },
    span_id: 'b0fc6eb249ecfa06',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}, {
  _index: '.ds-traces-generic.otel-default-2025.05.21-000001',
  _id: 'AZb0Lhl-A0VBFcV179Vn',
  _score: 0,
  _source: {
    '@timestamp': '2025-05-21T18:50:00.862Z',
    attributes: {
      'sinatra.template_name': 'confirmation'
    },
    data_stream: {
      dataset: 'generic.otel',
      namespace: 'default',
      type: 'traces'
    },
    duration: 6688875,
    kind: 'Internal',
    links: [],
    name: 'sinatra.render_template',
    parent_span_id: 'e5ce8a3b70153009',
    resource: {
      attributes: {
        'process.command': 'email_server.rb',
        'process.pid': 1,
        'process.runtime.description': 'ruby 3.2.2 (2023-03-30 revision e51014f9c0) [aarch64-linux]',
        'process.runtime.name': 'ruby',
        'process.runtime.version': '3.2.2',
        'service.name': 'email',
        'service.namespace': 'opentelemetry-demo',
        'service.version': '2.0.2',
        'telemetry.sdk.language': 'ruby',
        'telemetry.sdk.name': 'opentelemetry',
        'telemetry.sdk.version': '1.4.1'
      }
    },
    scope: {
      name: 'OpenTelemetry::Instrumentation::Sinatra',
      version: '0.23.5'
    },
    span_id: '0617e63bb0dd5a7a',
    status: {
      code: 'Unset'
    },
    trace_id: 'ed1aacaf31264b93e0e405e42b00af74'
  }
}];