"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Marker = Marker;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _agent_marker = require("./agent_marker");
var _error_marker = require("./error_marker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/marker/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MarkerContainer = _styled.default.div`
  position: absolute;
  bottom: 0;
`;
function Marker({
  mark,
  x
}) {
  const legendWidth = 11;
  return /*#__PURE__*/_react.default.createElement(MarkerContainer, {
    style: {
      left: x - legendWidth / 2
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, mark.type === 'errorMark' ? /*#__PURE__*/_react.default.createElement(_error_marker.ErrorMarker, {
    mark: mark,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 36
    }
  }) : /*#__PURE__*/_react.default.createElement(_agent_marker.AgentMarker, {
    mark: mark,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 66
    }
  }));
}