"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaOverview = SchemaOverview;
exports.SchemaOverviewHeading = SchemaOverviewHeading;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _blog_rocket_720x = _interopRequireDefault(require("./blog_rocket_720x420.png"));
var _migration_in_progress_panel = require("./migration_in_progress_panel");
var _upgrade_available_card = require("./migrated/upgrade_available_card");
var _successful_migration_card = require("./migrated/successful_migration_card");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/schema/schema_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SchemaOverview({
  onSwitch,
  isMigrating,
  isMigrated,
  isLoading,
  isLoadingConfirmation,
  cloudApmMigrationEnabled,
  hasCloudAgentPolicy,
  hasRequiredRole,
  cloudApmPackagePolicy,
  latestApmPackageVersion
}) {
  var _cloudApmPackagePolic;
  const isDisabled = !cloudApmMigrationEnabled || !hasCloudAgentPolicy || !hasRequiredRole;
  const packageVersion = cloudApmPackagePolicy === null || cloudApmPackagePolicy === void 0 ? void 0 : (_cloudApmPackagePolic = cloudApmPackagePolicy.package) === null || _cloudApmPackagePolic === void 0 ? void 0 : _cloudApmPackagePolic.version;
  const isUpgradeAvailable = packageVersion && (0, _lt.default)(packageVersion, latestApmPackageVersion);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })));
  }
  if (isMigrating && !isMigrated) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_migration_in_progress_panel.MigrationInProgressPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }));
  }
  if (isMigrated) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 2,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, isUpgradeAvailable ? /*#__PURE__*/_react.default.createElement(_upgrade_available_card.UpgradeAvailableCard, {
      apmPackagePolicyId: cloudApmPackagePolicy === null || cloudApmPackagePolicy === void 0 ? void 0 : cloudApmPackagePolicy.id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_successful_migration_card.SuccessfulMigrationCard, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '250px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "node",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 19
      }
    }),
    title: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.classicIndices.title', {
      defaultMessage: 'APM Server binary'
    }),
    display: "subdued",
    description: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.classicIndices.description', {
      defaultMessage: 'You are currently using APM Server binary. This legacy option is deprecated since version 7.16 and is being replaced by a managed APM Server in Elastic Agent from version 8.0.'
    }),
    footer: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.apm.settings.schema.migrate.classicIndices.currentSetup', {
      defaultMessage: 'Current setup'
    })))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '250px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    image: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: _blog_rocket_720x.default,
      alt: "rocket launch",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 17
      }
    })),
    title: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.dataStreams.title', {
      defaultMessage: 'Elastic Agent'
    }),
    description: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.dataStreams.description', {
      defaultMessage: 'Starting in version 8.0, APM Server is recommended to be managed by Elastic Agent. Elastic Agent can run on our hosted Elasticsearch Service, ECE, or be self-managed. Then, add the Elastic APM integration to continue ingesting APM data.'
    }),
    footer: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: getDisabledReason({
        cloudApmMigrationEnabled,
        hasCloudAgentPolicy,
        hasRequiredRole
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmSchemaOverviewSwitchToElasticAgentButton",
      fill: true,
      isLoading: isLoadingConfirmation,
      isDisabled: isDisabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.apm.settings.schema.migrate.dataStreams.buttonText', {
      defaultMessage: 'Switch to Elastic Agent'
    })))),
    onClick: onSwitch,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  })));
}
function SchemaOverviewHeading() {
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.settings.schema.descriptionText",
    defaultMessage: "We have created a simple and seamless process for switching from APM Server binary to Elastic Agent. Beware this action is {irreversibleEmphasis} and can only be performed by a {superuserEmphasis} with access to Fleet. Learn more about {elasticAgentDocLink}.",
    values: {
      irreversibleEmphasis: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.apm.settings.schema.descriptionText.irreversibleEmphasisText', {
        defaultMessage: 'irreversible'
      })),
      superuserEmphasis: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.apm.settings.schema.descriptionText.superuserEmphasisText', {
        defaultMessage: 'superuser'
      })),
      elasticAgentDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmSchemaOverviewHeadingElasticAgentLink",
        target: "_blank",
        href: docLinks.links.apm.elasticAgent,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.apm.settings.schema.descriptionText.elasticAgentDocLinkText', {
        defaultMessage: 'Elastic Agent'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }));
}
function getDisabledReason({
  cloudApmMigrationEnabled,
  hasCloudAgentPolicy,
  hasRequiredRole
}) {
  const reasons = [];
  if (!cloudApmMigrationEnabled) {
    reasons.push(_i18n.i18n.translate('xpack.apm.settings.schema.disabledReason.cloudApmMigrationEnabled', {
      defaultMessage: 'Cloud migration is not enabled'
    }));
  }
  if (hasRequiredRole && !hasCloudAgentPolicy) {
    reasons.push(_i18n.i18n.translate('xpack.apm.settings.schema.disabledReason.hasCloudAgentPolicy', {
      defaultMessage: 'Cloud agent policy does not exist'
    }));
  }
  if (!hasRequiredRole) {
    reasons.push(_i18n.i18n.translate('xpack.apm.settings.schema.disabledReason.hasRequiredRole', {
      defaultMessage: 'User does not have superuser role'
    }));
  }
  if (reasons.length) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.schema.disabledReason",
      defaultMessage: "Switch to Elastic Agent is unavailable: {reasons}",
      values: {
        reasons: /*#__PURE__*/_react.default.createElement("ul", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 263,
            columnNumber: 13
          }
        }, reasons.map((reasonText, index) => /*#__PURE__*/_react.default.createElement("li", {
          key: index,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 265,
            columnNumber: 17
          }
        }, "- ", reasonText)))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 7
      }
    });
  }
}