"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurationCreateEdit = AgentConfigurationCreateEdit;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../../shared/links/url_helpers");
var _service_page = require("./service_page/service_page");
var _settings_page = require("./settings_page/settings_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getInitialNewConfig(existingConfig) {
  return {
    agent_name: existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.agent_name,
    service: (existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.service) || {},
    settings: (existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.settings) || {}
  };
}
function setPage(pageStep, history) {
  history.push({
    ...history.location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(history.location.search),
      pageStep
    })
  });
}
function getUnsavedChanges({
  newConfig,
  existingConfig
}) {
  return Object.fromEntries(Object.entries(newConfig.settings).filter(([key, value]) => {
    var _existingConfig$setti;
    const existingValue = existingConfig === null || existingConfig === void 0 ? void 0 : (_existingConfig$setti = existingConfig.settings) === null || _existingConfig$setti === void 0 ? void 0 : _existingConfig$setti[key];

    // don't highlight changes that were added and removed
    if (value === '' && existingValue == null) {
      return false;
    }
    return existingValue !== value;
  }));
}
function AgentConfigurationCreateEdit({
  pageStep,
  existingConfigResult
}) {
  var _existingConfigResult;
  const history = (0, _reactRouterDom.useHistory)();
  const existingConfig = existingConfigResult === null || existingConfigResult === void 0 ? void 0 : existingConfigResult.data;
  const isEditMode = Boolean(existingConfigResult);
  const [newConfig, setNewConfig] = (0, _react.useState)(getInitialNewConfig(existingConfig));
  const resetSettings = (0, _react.useCallback)(() => {
    setNewConfig(_newConfig => ({
      ..._newConfig,
      settings: (existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.settings) || {}
    }));
  }, [existingConfig]);

  // update newConfig when existingConfig has loaded
  (0, _react.useEffect)(() => {
    setNewConfig(getInitialNewConfig(existingConfig));
  }, [existingConfig]);
  (0, _react.useEffect)(() => {
    // the user tried to edit the service of an existing config
    if (pageStep === 'choose-service-step' && isEditMode) {
      setPage('choose-settings-step', history);
    }

    // the user skipped the first step (select service)
    if (pageStep === 'choose-settings-step' && !isEditMode && (0, _lodash.isEmpty)(newConfig.service)) {
      setPage('choose-service-step', history);
    }
  }, [history, isEditMode, newConfig, pageStep]);
  const unsavedChanges = getUnsavedChanges({
    newConfig,
    existingConfig
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.agentConfig.newConfig.description', {
    defaultMessage: `Fine-tune your agent configuration. Changes are automatically propagated to your APM agents and EDOT SDKs, so there’s no need to redeploy.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), isEditMode && existingConfigResult !== null && existingConfigResult !== void 0 && (_existingConfigResult = existingConfigResult.data) !== null && _existingConfigResult !== void 0 && _existingConfigResult.error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.agentConfigurationCreateEdit.euiCallOut.errorApplyingConfigurationLabel', {
      defaultMessage: 'Error applying configuration'
    }),
    color: "danger",
    iconType: "error",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, existingConfigResult.data.error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, isEditMode ? _i18n.i18n.translate('xpack.apm.agentConfig.editConfigTitle', {
    defaultMessage: 'Edit configuration'
  }) : _i18n.i18n.translate('xpack.apm.agentConfig.createConfigTitle', {
    defaultMessage: 'Create configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }), pageStep === 'choose-service-step' && /*#__PURE__*/_react.default.createElement(_service_page.ServicePage, {
    newConfig: newConfig,
    setNewConfig: setNewConfig,
    onClickNext: () => {
      resetSettings();
      setPage('choose-settings-step', history);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), pageStep === 'choose-settings-step' && /*#__PURE__*/_react.default.createElement(_settings_page.SettingsPage, {
    initialConfig: existingConfigResult,
    unsavedChanges: unsavedChanges,
    onClickEdit: () => setPage('choose-service-step', history),
    newConfig: newConfig,
    setNewConfig: setNewConfig,
    resetSettings: resetSettings,
    isEditMode: isEditMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }));
}