"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _log_rate_analysis_table_slice = require("@kbn/aiops-log-rate-analysis/state/log_rate_analysis_table_slice");
var _log_rate_analysis_field_candidates_slice = require("@kbn/aiops-log-rate-analysis/state/log_rate_analysis_field_candidates_slice");
var _item_filter_popover = require("./item_filter_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const groupResultsMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResults', {
  defaultMessage: 'Smart grouping'
});
const fieldFilterHelpText = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.fieldFilterHelpText', {
  defaultMessage: 'Deselect non-relevant fields to remove them from the analysis and click the Apply button to rerun the analysis.  Use the search bar to filter the list, then select/deselect multiple fields with the actions below.'
});
const columnsFilterHelpText = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.columnsFilterHelpText', {
  defaultMessage: 'Configure visible columns.'
});
const disabledFieldFilterApplyButtonTooltipContent = _i18n.i18n.translate('xpack.aiops.analysis.fieldSelectorNotEnoughFieldsSelected', {
  defaultMessage: 'Grouping requires at least 2 fields to be selected.'
});
const disabledColumnFilterApplyButtonTooltipContent = _i18n.i18n.translate('xpack.aiops.analysis.columnSelectorNotEnoughColumnsSelected', {
  defaultMessage: 'At least one column must be selected.'
});
const columnSearchAriaLabel = _i18n.i18n.translate('xpack.aiops.analysis.columnSelectorAriaLabel', {
  defaultMessage: 'Filter columns'
});
const columnsButton = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.columnsFilterButtonLabel', {
  defaultMessage: 'Columns'
});
const fieldsButton = _i18n.i18n.translate('xpack.aiops.analysis.fieldsButtonLabel', {
  defaultMessage: 'Fields'
});
const groupResultsOffMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsOff', {
  defaultMessage: 'Off'
});
const groupResultsOnMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsOn', {
  defaultMessage: 'On'
});
const resultsGroupedOffId = 'aiopsLogRateAnalysisGroupingOff';
const resultsGroupedOnId = 'aiopsLogRateAnalysisGroupingOn';
const LogRateAnalysisOptions = ({
  foundGroups,
  growFirstItem = false
}) => {
  const dispatch = (0, _state.useAppDispatch)();
  const {
    groupResults
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    isRunning
  } = (0, _state.useAppSelector)(s => s.stream);
  const fieldCandidates = (0, _state.useAppSelector)(s => s.logRateAnalysisFieldCandidates);
  const {
    skippedColumns
  } = (0, _state.useAppSelector)(s => s.logRateAnalysisTable);
  const {
    fieldFilterUniqueItems,
    initialFieldFilterSkippedItems
  } = fieldCandidates;
  const fieldFilterButtonDisabled = isRunning || fieldCandidates.isLoading || fieldFilterUniqueItems.length === 0;
  const toggleIdSelected = groupResults ? resultsGroupedOnId : resultsGroupedOffId;
  const onGroupResultsToggle = optionId => {
    dispatch((0, _state.setGroupResults)(optionId === resultsGroupedOnId));
    // When toggling the group switch, clear all row selections
    dispatch((0, _state.clearAllRowState)());
  };
  const onVisibleColumnsChange = columns => {
    dispatch((0, _log_rate_analysis_table_slice.setSkippedColumns)(columns));
  };
  const onFieldsFilterChange = skippedFieldsUpdate => {
    dispatch((0, _log_rate_analysis_field_candidates_slice.setCurrentFieldFilterSkippedItems)(skippedFieldsUpdate));
  };

  // Disable the grouping switch toggle only if no groups were found,
  // the toggle wasn't enabled already and no fields were selected to be skipped.
  const disabledGroupResultsSwitch = !foundGroups && !groupResults;
  const toggleButtons = [{
    id: resultsGroupedOffId,
    label: groupResultsOffMessage,
    'data-test-subj': 'aiopsLogRateAnalysisGroupSwitchOff'
  }, {
    id: resultsGroupedOnId,
    label: groupResultsOnMessage,
    'data-test-subj': 'aiopsLogRateAnalysisGroupSwitchOn'
  }];

  // Temporarily hide smart grouping controls as it is disabled until https://github.com/elastic/kibana/issues/232849 is resolved
  const smartGroupingDisabled = true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, smartGroupingDisabled ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: growFirstItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, groupResultsMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": `aiopsLogRateAnalysisGroupSwitch${groupResults ? ' checked' : ''}`,
    buttonSize: "s",
    isDisabled: disabledGroupResultsSwitch,
    legend: groupResultsMessage,
    options: toggleButtons,
    idSelected: toggleIdSelected,
    onChange: onGroupResultsToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_item_filter_popover.ItemFilterPopover, {
    dataTestSubj: "aiopsFieldFilterButton",
    disabled: fieldFilterButtonDisabled,
    disabledApplyButton: fieldFilterButtonDisabled,
    disabledApplyTooltipContent: disabledFieldFilterApplyButtonTooltipContent,
    helpText: fieldFilterHelpText,
    itemSearchAriaLabel: fieldsButton,
    popoverButtonTitle: fieldsButton,
    selectedItemLimit: 1,
    uniqueItemNames: fieldFilterUniqueItems,
    initialSkippedItems: initialFieldFilterSkippedItems,
    onChange: onFieldsFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_item_filter_popover.ItemFilterPopover, {
    dataTestSubj: "aiopsColumnFilterButton",
    disabled: isRunning,
    disabledApplyButton: isRunning,
    disabledApplyTooltipContent: disabledColumnFilterApplyButtonTooltipContent,
    helpText: columnsFilterHelpText,
    itemSearchAriaLabel: columnSearchAriaLabel,
    initialSkippedItems: skippedColumns,
    popoverButtonTitle: columnsButton,
    selectedItemLimit: 1,
    uniqueItemNames: groupResults ? Object.values(_log_rate_analysis_table_slice.commonColumns) : Object.values(_log_rate_analysis_table_slice.significantItemColumns),
    onChange: onVisibleColumnsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  })));
};
exports.LogRateAnalysisOptions = LogRateAnalysisOptions;