"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.focus = void 0;
var _utils = require("../../../../services/theme/utils");
var _manipulation = require("../../../../services/color/manipulation");
var _size = require("../../../../global_styling/functions/size");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var focus = exports.focus = {
  // Focus ring
  color: 'currentColor',
  width: (0, _utils.computed)((0, _size.sizeToPixel)(0.125)),
  // Focus background
  transparency: {
    LIGHT: 0.1,
    DARK: 0.2
  },
  backgroundColor: (0, _utils.computed)(function (_ref) {
    var colors = _ref.colors,
      focus = _ref.focus;
    return (0, _manipulation.transparentize)(colors.primary, focus.transparency);
  })
};