"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildShipperHeaders = exports.buildShipperUrl = void 0;
var tslib_1 = require("tslib");
var buildShipperUrl = function (urlOptions) {
    var channelName = urlOptions.channelName;
    var baseUrl = 'https://telemetry-staging.elastic.co';
    return "".concat(baseUrl, "/v3/send/").concat(channelName);
};
exports.buildShipperUrl = buildShipperUrl;
var buildShipperHeaders = function (clusterUuid, version, licenseId) {
    return tslib_1.__assign({ 'content-type': 'application/x-ndjson', 'x-elastic-cluster-id': clusterUuid, 'x-elastic-stack-version': version }, (licenseId && { 'x-elastic-license-id': licenseId }));
};
exports.buildShipperHeaders = buildShipperHeaders;
