"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAccessorFn = getAccessorFn;
exports.getAccessorFormatLabel = getAccessorFormatLabel;
exports.getAccessorValue = getAccessorValue;
function getAccessorFn(accessor) {
    return (datum) => typeof datum === 'object' && datum !== null ? datum[accessor] : undefined;
}
function getAccessorFormatLabel(accessor, label) {
    if (typeof accessor === 'string') {
        return `${label}${accessor}`;
    }
    return accessor(label);
}
function getAccessorValue(datum, accessor) {
    if (typeof accessor === 'function') {
        return accessor(datum);
    }
    try {
        return datum[accessor];
    }
    catch {
        return undefined;
    }
}
//# sourceMappingURL=accessor.js.map