"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.angularBullet = angularBullet;
const text_utils_1 = require("../../../../../common/text_utils");
const debug_1 = require("../../../../../renderers/canvas/utils/debug");
const canvas_text_bbox_calculator_1 = require("../../../../../utils/bbox/canvas_text_bbox_calculator");
const common_1 = require("../../../../../utils/common");
const lines_1 = require("../../../../xy_chart/renderer/canvas/lines");
const spec_1 = require("../../../spec");
const theme_1 = require("../../../theme");
const angular_1 = require("../../../utils/angular");
const constants_1 = require("../constants");
function angularBullet(ctx, dimensions, style, backgroundColor, spec, debug, activeValue) {
    const { datum, graphArea, scale, ticks, colorBands } = dimensions;
    const { radius } = (0, angular_1.getAngledChartSizing)(graphArea.size, spec.subtype);
    const [startAngle, endAngle] = scale.range();
    const center = {
        x: graphArea.center.x,
        y: radius + constants_1.TARGET_SIZE / 2,
    };
    ctx.translate(theme_1.GRAPH_PADDING.left, theme_1.GRAPH_PADDING.top);
    const [start, end] = scale.domain();
    const counterClockwise = startAngle < endAngle && start > end;
    const [min, max] = (0, common_1.sortNumbers)([start, end]);
    const filteredTicks = spec.subtype !== spec_1.BulletSubtype.circle
        ? ticks
        : min === ticks.at(0) && max === ticks.at(-1)
            ? ticks.slice(0, -1)
            : max === ticks.at(0) && min === ticks.at(-1)
                ? ticks.slice(1)
                : ticks;
    const formatterColorTicks = filteredTicks.map((v) => ({ value: v, formattedValue: datum.tickFormatter(v) }));
    colorBands.forEach((band) => {
        ctx.beginPath();
        ctx.arc(center.x, center.y, radius, band.start, band.end, false);
        ctx.lineWidth = constants_1.BULLET_SIZE;
        ctx.strokeStyle = band.color;
        ctx.stroke();
    });
    ctx.beginPath();
    ctx.strokeStyle = backgroundColor;
    ctx.lineWidth = constants_1.TICK_WIDTH;
    formatterColorTicks
        .filter((tick) => tick.value > min && tick.value < max)
        .forEach((tick) => {
        const bulletWidth = constants_1.BULLET_SIZE + 4;
        (0, lines_1.drawPolarLine)(ctx, scale(tick.value), radius, bulletWidth, center);
    });
    ctx.stroke();
    const confinedValue = (0, common_1.clamp)(datum.value, min, max);
    const adjustedZero = (0, common_1.clamp)(0, min, max);
    ctx.beginPath();
    ctx.lineWidth = constants_1.BAR_SIZE;
    ctx.strokeStyle = style.barBackground;
    ctx.arc(center.x, center.y, radius, confinedValue > 0 ? scale(adjustedZero) : scale(confinedValue), confinedValue > 0 ? scale(confinedValue) : scale(adjustedZero), counterClockwise);
    ctx.stroke();
    if ((0, common_1.isFiniteNumber)(datum.target) && datum.target <= max && datum.target >= min) {
        ctx.beginPath();
        ctx.strokeStyle = style.barBackground;
        ctx.lineWidth = constants_1.TARGET_STROKE_WIDTH;
        (0, lines_1.drawPolarLine)(ctx, scale(datum.target), radius, constants_1.TARGET_SIZE, center);
        ctx.stroke();
    }
    if ((0, common_1.isBetween)(min, max, true)(0)) {
        ctx.beginPath();
        ctx.strokeStyle = style.barBackground;
        ctx.lineWidth = constants_1.TICK_WIDTH;
        (0, lines_1.drawPolarLine)(ctx, scale(0), radius, constants_1.BULLET_SIZE, center);
        ctx.stroke();
    }
    const measure = (0, canvas_text_bbox_calculator_1.measureText)(ctx);
    const maxTickWidth = formatterColorTicks.reduce((acc, t) => {
        const { width } = measure(t.formattedValue, theme_1.TICK_FONT, theme_1.TICK_FONT_SIZE);
        return Math.max(acc, width);
    }, 0);
    ctx.fillStyle = style.textColor;
    ctx.textBaseline = 'middle';
    ctx.font = (0, text_utils_1.cssFontShorthand)(theme_1.TICK_FONT, theme_1.TICK_FONT_SIZE);
    formatterColorTicks
        .filter((tick) => tick.value >= min && tick.value <= max)
        .forEach((tick) => {
        ctx.textAlign = 'center';
        const textPadding = style.angularTickLabelPadding + maxTickWidth / 2;
        const start = scale(tick.value);
        const y1 = Math.sin(start) * (radius - constants_1.BULLET_SIZE / 2 - textPadding);
        const x1 = Math.cos(start) * (radius - constants_1.BULLET_SIZE / 2 - textPadding);
        ctx.fillText(tick.formattedValue, center.x + x1, center.y + y1);
    });
    if (activeValue) {
        ctx.beginPath();
        ctx.strokeStyle = style.barBackground;
        ctx.lineWidth = constants_1.TARGET_STROKE_WIDTH;
        (0, lines_1.drawPolarLine)(ctx, activeValue.value, radius, constants_1.TARGET_SIZE, center);
        ctx.stroke();
    }
    ctx.beginPath();
    if (debug) {
        (0, debug_1.renderDebugPoint)(ctx, center.x, center.y);
    }
}
//# sourceMappingURL=angular.js.map