"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadinessPillarCards = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_readiness_tasks_stats = require("../hooks/use_readiness_tasks_stats");
var _use_pillar_props = require("../hooks/use_pillar_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_readiness/pages/readiness_pillar_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Color constants
const BRONZE_COLOR = '#966B03';
const SILVER_COLOR = '#5A6D8C';
const GOLD_COLOR = '#F5BC00';
const CARDS_HEIGHT = 240;
const PROGRESS_BAR_SIZE = 120;
const PillarDetails = ({
  pillarProps,
  pillarStats
}) => {
  const {
    completed,
    total
  } = pillarStats;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: completed,
    max: total,
    size: "m",
    color: pillarProps.color,
    css: {
      transform: 'rotate(-90deg)',
      position: 'absolute',
      top: '70px',
      left: '-42px',
      width: PROGRESS_BAR_SIZE
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    css: {
      height: '100%',
      paddingLeft: euiTheme.size.base,
      minHeight: PROGRESS_BAR_SIZE
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "baseline",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 17
    }
  }, `${completed}/${total}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.tasksCompletedLabel', {
    defaultMessage: 'Tasks completed'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    style: {
      marginBottom: euiTheme.size.xxs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, pillarProps.displayName)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, pillarProps.description))))));
};
const PillarLevelProgress = ({
  pillarProps,
  pillarStats
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    completed,
    total
  } = pillarStats;

  // Calculate level thresholds
  const bronzeThreshold = 1;
  const silverThreshold = Math.ceil(total / 2);
  const goldThreshold = total;

  // Determine current level and tasks to next level
  let tasksToNextLevel = 0;
  if (completed >= goldThreshold) {
    tasksToNextLevel = 0;
  } else if (completed >= silverThreshold) {
    tasksToNextLevel = goldThreshold - completed;
  } else if (completed >= bronzeThreshold) {
    tasksToNextLevel = silverThreshold - completed;
  } else {
    tasksToNextLevel = bronzeThreshold - completed;
  }

  // Calculate progress percentage for the progress bar
  const progressValue = completed;
  const progressMax = total;

  // Determine which levels have been reached
  const bronzeReached = completed >= bronzeThreshold;
  const silverReached = completed >= silverThreshold;
  const goldReached = completed >= goldThreshold;
  const levelUnreachedColor = euiTheme.colors.severity.unknown;
  const levelColors = {
    bronze: bronzeReached ? BRONZE_COLOR : levelUnreachedColor,
    silver: silverReached ? SILVER_COLOR : levelUnreachedColor,
    gold: goldReached ? GOLD_COLOR : levelUnreachedColor
  };
  const commonStyle = {
    position: 'absolute',
    top: '-5px',
    display: 'flex',
    flexDirection: 'column',
    alignItems: 'center'
  };
  const shields = [{
    key: 'bronze',
    left: '0%',
    transform: 'translateX(-50%)',
    color: levelColors.bronze,
    label: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.bronzeLevelLabel', {
      defaultMessage: 'Bronze'
    })
  }, {
    key: 'silver',
    left: 'calc(50% - 8px)',
    transform: 'none',
    color: levelColors.silver,
    label: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.silverLevelLabel', {
      defaultMessage: 'Silver'
    })
  }, {
    key: 'gold',
    left: '100%',
    transform: 'translateX(-50%)',
    color: levelColors.gold,
    label: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.goldLevelLabel', {
      defaultMessage: 'Gold'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.yourCurrentLevelLabel', {
    defaultMessage: 'Your current level'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, tasksToNextLevel > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "bullseye",
    color: euiTheme.colors.backgroundTransparentPlain,
    css: {
      color: euiTheme.colors.primary
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.tasksToNextLevelBadge', {
    defaultMessage: '{count} tasks to next level',
    values: {
      count: tasksToNextLevel
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "check",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.allTasksCompleteBadge', {
    defaultMessage: 'All tasks complete'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      padding: '0 16px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    color: pillarProps.color,
    value: progressValue,
    max: progressMax,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }), shields.map(shield => /*#__PURE__*/_react.default.createElement("div", {
    key: shield.key,
    style: {
      ...commonStyle,
      left: shield.left,
      transform: shield.transform
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ShieldIcon, {
    color: shield.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      marginTop: euiTheme.size.xxs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  }, shield.label)))))));
};
const PillarCard = ({
  pillarProps,
  pillarStats
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PillarDetails, {
    pillarProps: pillarProps,
    pillarStats: pillarStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PillarLevelProgress, {
    pillarProps: pillarProps,
    pillarStats: pillarStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }))));
};
const ReadinessPillarCards = () => {
  const {
    pillarPropsMap
  } = (0, _use_pillar_props.usePillarsProps)();
  const {
    readinessTasksStats
  } = (0, _use_readiness_tasks_stats.useReadinessTasksStats)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    style: {
      height: CARDS_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 5
    }
  }, Object.values(pillarPropsMap).map(pillar => {
    const stats = readinessTasksStats.pillarStatsMap[pillar.pillarKey];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: pillar.pillarKey,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(PillarCard, {
      pillarProps: pillar,
      pillarStats: stats,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 13
      }
    }));
  }));
};
exports.ReadinessPillarCards = ReadinessPillarCards;
const ShieldIcon = ({
  color = BRONZE_COLOR,
  width = 16,
  height = 16
}) => /*#__PURE__*/_react.default.createElement("svg", {
  width: width,
  height: height,
  viewBox: "0 0 15 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  style: {
    color
  } // this works because fill="currentColor"
  ,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 270,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("svg", {
  width: "15",
  height: "16",
  viewBox: "0 0 15 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 278,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M7.56108 1.14412L12.9756 2.28524C13.112 2.31384 13.2095 2.43411 13.2095 2.57419V8.13605C13.2095 9.62186 12.6052 11.1488 11.5081 12.4344C10.4454 13.6789 9.00661 14.5649 7.55969 14.864C7.53988 14.8676 7.52008 14.8698 7.50028 14.8698C7.48048 14.8698 7.45995 14.8676 7.44015 14.864C5.99395 14.5648 4.55436 13.6789 3.49249 12.4344C2.39537 11.1488 1.79108 9.6226 1.79108 8.13605V2.57419C1.79108 2.43485 1.88862 2.31458 2.02503 2.28524L7.43951 1.14412C7.47911 1.13606 7.52074 1.13606 7.56108 1.14412ZM12.619 2.814L7.50006 1.73521L2.38108 2.814V8.13611C2.38108 10.8694 4.71904 13.6649 7.50006 14.273C10.2809 13.6651 12.619 10.8694 12.619 8.13611V2.814ZM10.248 4.86226L6.51441 8.59589L4.75213 6.83361C4.637 6.71847 4.44998 6.71847 4.33484 6.83361C4.2197 6.94875 4.2197 7.13576 4.33484 7.25091L6.30613 9.2222C6.36114 9.2772 6.43667 9.30874 6.51515 9.30874C6.59362 9.30874 6.66842 9.27793 6.72416 9.2222L10.666 5.28036C10.7811 5.16523 10.7811 4.97821 10.666 4.86307C10.5501 4.7472 10.3632 4.74712 10.248 4.86226ZM14.316 8.13611V1.43672L7.50006 6.10352e-05L0.684082 1.43672V8.13611C0.684082 11.8052 3.80098 15.395 7.50006 16.0001C11.1991 15.395 14.316 11.8052 14.316 8.13611Z",
  fill: "currentColor",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 279,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement("path", {
  d: "M10.248 4.86226L6.51441 8.59589L4.75213 6.83361C4.637 6.71847 4.44998 6.71847 4.33484 6.83361C4.2197 6.94875 4.2197 7.13576 4.33484 7.25091L6.30613 9.2222C6.36114 9.2772 6.43667 9.30874 6.51515 9.30874C6.59362 9.30874 6.66842 9.27793 6.72416 9.2222L10.666 5.28036C10.7811 5.16523 10.7811 4.97821 10.666 4.86307C10.5501 4.7472 10.3632 4.74712 10.248 4.86226Z",
  fill: "white",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 285,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M7.56108 1.14412L12.9756 2.28524C13.112 2.31384 13.2095 2.43411 13.2095 2.57419V8.13605C13.2095 9.62186 12.6052 11.1488 11.5081 12.4344C10.4454 13.6789 9.00661 14.5649 7.55969 14.864C7.53988 14.8676 7.52008 14.8698 7.50028 14.8698C7.48048 14.8698 7.45995 14.8676 7.44015 14.864C5.99395 14.5648 4.55436 13.6789 3.49249 12.4344C2.39537 11.1488 1.79108 9.6226 1.79108 8.13605V2.57419C1.79108 2.43485 1.88862 2.31458 2.02503 2.28524L7.43951 1.14412C7.47911 1.13606 7.52074 1.13606 7.56108 1.14412ZM7.50006 1.73521L12.619 2.814V8.13611C12.619 10.8694 10.2809 13.6651 7.50006 14.273C4.71904 13.6649 2.38108 10.8694 2.38108 8.13611V2.814L7.50006 1.73521Z",
  fill: "white",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 289,
    columnNumber: 7
  }
})));