"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationResultPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _chartsTheme = require("@kbn/charts-theme");
var _react2 = require("@emotion/react");
var _panel_text = require("../../../../common/components/panel_text");
var _utils = require("../../../common/utils");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
var _centered_loading_spinner = require("../../../../common/components/centered_loading_spinner");
var _links = require("../../../../common/components/links");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _upload_missing_panel = require("./upload_missing_panel");
var _last_error = require("../../../common/components/migration_panels/last_error");
var _migration_title = require("../../../common/components/migration_panels/migration_title");
var _use_complete_status_badge_styles = require("../../../common/hooks/use_complete_status_badge_styles");
var _total_execution_time = require("../../../common/components/total_execution_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/migration_status_panels/migration_result_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const headerStyle = (0, _react2.css)`
  &:hover {
    cursor: pointer;
    text-decoration: underline;
  }
`;
const DashboardMigrationResultPanel = exports.DashboardMigrationResultPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  isCollapsed = false,
  onToggleCollapsed
}) => {
  var _migrationStats$last_, _migrationStats$last_2;
  const {
    data: translationStats,
    isLoading: isLoadingTranslationStats
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationStats.id);
  const completeBadgeStyles = (0, _use_complete_status_badge_styles.useCompleteBadgeStyles)();
  const toggleCollapsed = (0, _react.useCallback)(() => {
    onToggleCollapsed(!isCollapsed);
  }, [isCollapsed, onToggleCollapsed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    onClick: toggleCollapsed,
    css: headerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_migration_title.MigrationPanelTitle, {
    migrationStats: migrationStats,
    migrationType: "dashboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    subdued: true,
    "data-test-subj": "migrationPanelDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 21
    }
  }, i18n.DASHBOARD_MIGRATION_COMPLETE_DESCRIPTION((0, _moment.default)(migrationStats.created_at).format('MMMM Do YYYY, h:mm:ss a'), (0, _moment.default)(migrationStats.last_updated_at).fromNow())), ((_migrationStats$last_ = migrationStats.last_execution) === null || _migrationStats$last_ === void 0 ? void 0 : _migrationStats$last_.total_execution_time_ms) && /*#__PURE__*/_react.default.createElement(_total_execution_time.TotalExecutionTime, {
    migrationType: "dashboard",
    milliseconds: migrationStats.last_execution.total_execution_time_ms,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: completeBadgeStyles,
    "data-test-subj": "migrationCompleteBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }, i18n.DASHBOARD_MIGRATION_COMPLETE_BADGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isCollapsed ? 'arrowDown' : 'arrowUp',
    onClick: toggleCollapsed,
    "aria-label": isCollapsed ? i18n.DASHBOARD_MIGRATION_EXPAND : i18n.DASHBOARD_MIGRATION_COLLAPSE,
    "data-test-subj": "collapseButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: migrationStats.id,
    initialIsOpen: !isCollapsed,
    forceState: isCollapsed ? 'closed' : 'open',
    arrowDisplay: 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, ((_migrationStats$last_2 = migrationStats.last_execution) === null || _migrationStats$last_2 === void 0 ? void 0 : _migrationStats$last_2.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_last_error.MigrationsLastError, {
    message: migrationStats.last_execution.error,
    migrationType: "dashboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _aiAssistantIcon.AssistantIcon,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    semiBold: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 23
    }
  }, i18n.DASHBOARD_MIGRATION_SUMMARY_TITLE))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 21
    }
  }, isLoadingTranslationStats ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 25
    }
  }) : translationStats && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    css: {
      textAlign: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 31
    }
  }, i18n.DASHBOARD_MIGRATION_SUMMARY_CHART_TITLE)), /*#__PURE__*/_react.default.createElement(TranslationResultsChart, {
    translationStats: translationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(TranslationResultsTable, {
    translationStats: translationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 29
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards,
    path: migrationStats.id,
    "data-test-subj": "viewDashboardsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 27
    }
  }, i18n.DASHBOARD_MIGRATION_VIEW_TRANSLATED_DASHBOARDS_BUTTON)))))))), /*#__PURE__*/_react.default.createElement(_upload_missing_panel.DashboardMigrationsUploadMissingPanel, {
    migrationStats: migrationStats,
    topSpacerSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }))));
});
DashboardMigrationResultPanel.displayName = 'MigrationResultPanel';
const TranslationResultsChart = /*#__PURE__*/_react.default.memo(({
  translationStats
}) => {
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const translationResultColors = (0, _utils.useResultVisColors)();
  const data = [{
    category: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.FULL),
    value: translationStats.dashboards.success.result.full
  }, {
    category: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.PARTIAL),
    value: translationStats.dashboards.success.result.partial
  }, {
    category: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.UNTRANSLATABLE),
    value: translationStats.dashboards.success.result.untranslatable
  }, {
    category: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS,
    type: i18n.DASHBOARD_MIGRATION_TRANSLATION_FAILED,
    value: translationStats.dashboards.failed
  }];
  const colors = [translationResultColors[_constants.MigrationTranslationResult.FULL], translationResultColors[_constants.MigrationTranslationResult.PARTIAL], translationResultColors[_constants.MigrationTranslationResult.UNTRANSLATABLE], translationResultColors.error];
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 130
    },
    "data-test-subj": "translationResultsChart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    baseTheme: baseTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "results",
    name: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS,
    data: data,
    xAccessor: "category",
    yAccessors: ['value'],
    splitSeriesAccessors: ['type'],
    stackAccessors: ['category'],
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    color: colors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }));
});
TranslationResultsChart.displayName = 'TranslationResultsChart';
const columns = [{
  field: 'title',
  name: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS,
  render: (title, {
    color
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    textSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `translationStatus-${title}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }, title, " "))
}, {
  field: 'value',
  name: i18n.DASHBOARD_MIGRATION_TABLE_COLUMN_DASHBOARDS,
  align: 'right',
  render: (value, {
    title
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": `translationStatusCount-${title}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }, value)
}];
const TranslationResultsTable = /*#__PURE__*/_react.default.memo(({
  translationStats
}) => {
  const translationResultColors = (0, _utils.useResultVisColors)();
  const items = (0, _react.useMemo)(() => [{
    title: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.FULL),
    value: translationStats.dashboards.success.result.full,
    color: translationResultColors[_constants.MigrationTranslationResult.FULL]
  }, {
    title: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.PARTIAL),
    value: translationStats.dashboards.success.result.partial,
    color: translationResultColors[_constants.MigrationTranslationResult.PARTIAL]
  }, {
    title: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.UNTRANSLATABLE),
    value: translationStats.dashboards.success.result.untranslatable,
    color: translationResultColors[_constants.MigrationTranslationResult.UNTRANSLATABLE]
  }, {
    title: i18n.DASHBOARD_MIGRATION_TRANSLATION_FAILED,
    value: translationStats.dashboards.failed,
    color: translationResultColors.error
  }], [translationStats, translationResultColors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "translatedResultsTable",
    items: items,
    columns: columns,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 5
    }
  });
});
TranslationResultsTable.displayName = 'TranslationResultsTable';