"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsUploadSubSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _get_eui_step_status = require("../../../../../../common/utils/get_eui_step_status");
var _components = require("../../../../../../common/components");
var _copy_export_query = require("./copy_export_query");
var _dashboards_file_upload = require("./dashboards_file_upload");
var _kibana_react = require("../../../../../../../common/lib/kibana/kibana_react");
var _check_resources = require("../../common/check_resources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/steps/upload_dashboards/sub_steps/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const END = 4;
const DashboardsUploadSubSteps = exports.DashboardsUploadSubSteps = /*#__PURE__*/_react.default.memo(function DashboardsUploadSubSteps({
  migrationStats,
  onMissingResourcesFetched,
  onMigrationCreated
}) {
  const [subStep, setSubStep] = (0, _react.useState)(migrationStats ? 4 : 1);
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.dashboards;
  const [migrationName, setMigrationName] = (0, _react.useState)(migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.name);
  const [isDashboardsFileReady, setIsDashboardFileReady] = (0, _react.useState)(false);

  // Migration name step
  const setName = (0, _react.useCallback)(name => {
    setMigrationName(name);
    if (name) {
      setSubStep(isDashboardsFileReady ? 3 : 2);
    } else {
      setSubStep(1);
    }
  }, [isDashboardsFileReady]);
  const nameStep = (0, _components.useMigrationNameStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(1, subStep),
    setMigrationName: setName,
    migrationName
  });

  // Copy query step
  const onCopied = (0, _react.useCallback)(() => {
    setSubStep(currentSubStep => currentSubStep !== 1 ? 3 : currentSubStep); // Move to the next step only if step 1 was completed
    telemetry.reportSetupQueryCopied({
      migrationId: migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id
    });
  }, [telemetry, migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id]);
  const copyStep = (0, _copy_export_query.useCopyExportQueryStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(2, subStep),
    onCopied
  });

  // Upload dashboards step
  const onMigrationCreatedStep = (0, _react.useCallback)(stats => {
    onMigrationCreated(stats);
    setSubStep(4);
  }, [onMigrationCreated]);
  const onDashboardsFileChanged = (0, _react.useCallback)(files => {
    setIsDashboardFileReady(!!(files !== null && files !== void 0 && files.length));
    setSubStep(3);
  }, []);
  const uploadStep = (0, _dashboards_file_upload.useDashboardsFileUploadStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(3, subStep),
    migrationStats,
    onDashboardsFileChanged,
    onMigrationCreated: onMigrationCreatedStep,
    migrationName
  });

  // Check missing resources step
  const onMissingResourcesFetchedStep = (0, _react.useCallback)(missingResources => {
    onMissingResourcesFetched(missingResources);
    setSubStep(END);
  }, [onMissingResourcesFetched]);
  const resourcesStep = (0, _check_resources.useCheckResourcesStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(4, subStep),
    migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetchedStep
  });
  const steps = (0, _react.useMemo)(() => [nameStep, copyStep, uploadStep, resourcesStep], [nameStep, copyStep, uploadStep, resourcesStep]);
  return /*#__PURE__*/_react.default.createElement(_components.SubSteps, {
    steps: steps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 10
    }
  });
});