"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../common/constants");
var _ = require("../app/404");
var _rule_management = require("../detection_engine/rule_management_ui/pages/rule_management");
var _rule_creation = require("../detection_engine/rule_creation_ui/pages/rule_creation");
var _rule_details = require("../detection_engine/rule_details_ui/pages/rule_details");
var _rule_editing = require("../detection_engine/rule_creation_ui/pages/rule_editing");
var _use_readonly_header = require("../use_readonly_header");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _rules_table_toolbar = require("../detection_engine/rule_management_ui/components/rules_table/rules_table_toolbar");
var _add_rules = require("../detection_engine/rule_management_ui/pages/add_rules");
var _landing = require("./landing");
var _coverage_overview = require("../detection_engine/rule_management_ui/pages/coverage_overview");
var _use_rule_details_tabs = require("../detection_engine/rule_details_ui/pages/rule_details/use_rule_details_tabs");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _capabilities = require("../common/lib/capabilities");
var _kibana_react = require("../common/lib/kibana/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/rules/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getRulesSubRoutes = capabilities => [...((0, _capabilities.hasCapabilities)(capabilities, `${_constants.SECURITY_FEATURE_ID}.detections`) // regular detection rules are enabled
? [{
  path: '/rules/id/:detailName/edit',
  main: _rule_editing.EditRulePage,
  exact: true
}, {
  path: `/rules/:tabName(${_rules_table_toolbar.AllRulesTabs.management}|${_rules_table_toolbar.AllRulesTabs.monitoring}|${_rules_table_toolbar.AllRulesTabs.updates})`,
  main: _rule_management.RulesPage,
  exact: true
}] : []), ...((0, _capabilities.hasCapabilities)(capabilities, [`${_constants.SECURITY_FEATURE_ID}.detections`, `${_constants.SECURITY_FEATURE_ID}.external_detections`]) // some detection capability is enabled
? [{
  path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.alerts}|${_use_rule_details_tabs.RuleDetailTabs.exceptions}|${_use_rule_details_tabs.RuleDetailTabs.endpointExceptions}|${_use_rule_details_tabs.RuleDetailTabs.executionResults}|${_use_rule_details_tabs.RuleDetailTabs.executionEvents})`,
  main: _rule_details.RuleDetailsPage,
  exact: true
}] : []), {
  path: '/rules/create',
  main: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(_rule_creation.CreateRulePage, _constants.SecurityPageName.rulesCreate, {
    omitSpyRoute: true
  }),
  exact: true
}, {
  path: '/rules/add_rules',
  main: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(_add_rules.AddRulesPage, _constants.SecurityPageName.rulesAdd, {
    omitSpyRoute: true
  }),
  exact: true
}];
const RulesContainerComponent = () => {
  (0, _use_readonly_header.useReadonlyHeader)(i18n.READ_ONLY_BADGE_TOOLTIP);
  const {
    capabilities
  } = (0, _kibana_react.useKibana)().services.application;
  const subRoutes = (0, _react.useMemo)(() => {
    return getRulesSubRoutes(capabilities).map(route => {
      var _route$exact;
      return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
        key: `rules-route-${route.path}`,
        path: route.path,
        exact: (_route$exact = route === null || route === void 0 ? void 0 : route.exact) !== null && _route$exact !== void 0 ? _route$exact : false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(route.main, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      }));
    });
  }, [capabilities]);
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to first tab if none specified
  , {
    path: "/rules/id/:detailName",
    exact: true,
    render: ({
      match: {
        params: {
          detailName
        }
      },
      location
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        ...location,
        pathname: `/rules/id/${detailName}/${_use_rule_details_tabs.RuleDetailTabs.alerts}`,
        search: location.search
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/rules",
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/rules/${_rules_table_toolbar.AllRulesTabs.management}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })), subRoutes, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.rules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })));
};
const Rules = /*#__PURE__*/_react.default.memo(RulesContainerComponent);
const CoverageOverviewRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 128,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_coverage_overview.CoverageOverviewPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 129,
    columnNumber: 5
  }
}));
const routes = exports.routes = [{
  path: _constants.RULES_LANDING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(_landing.RulesLandingPage, _constants.SecurityPageName.rulesLanding, {
    omitSpyRoute: true
  })
}, {
  path: _constants.RULES_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(Rules, _constants.SecurityPageName.rules, {
    omitSpyRoute: true
  })
}, {
  path: _constants.COVERAGE_OVERVIEW_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(CoverageOverviewRoutes, _constants.SecurityPageName.coverageOverview)
}];