"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockResolver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _immer = require("immer");
var _resolver_without_providers = require("../../view/resolver_without_providers");
var _side_effect_context = require("../../view/side_effect_context");
var _mock = require("../../../common/mock");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/test_utilities/simulator/mock_resolver.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
(0, _immer.enableMapSet)();
/**
 * This is a mock Resolver component. It is intended to be used with `enzyme` tests via the `Simulator` class. It wraps Resolver in the required providers:
 *  * `i18n`
 *  * `Router` using a provided `History`
 *  * `SideEffectContext.Provider` using side effect simulator it creates
 *  * `KibanaContextProvider` using a provided `CoreStart` instance
 *  * `react-redux`'s `Provider` using a provided `Store`.
 *
 * Resolver needs to measure its size in the DOM. The `SideEffectSimulator` instance can fake the size of an element.
 * However in tests, React doesn't have good DOM reconciliation and the root element is often swapped out. When the
 * element is replaced, the fake dimensions stop being applied. In order to get around this issue, this component will
 * trigger a simulated resize on the root node reference any time it changes. This simulates the layout process a real
 * browser would do when an element is attached to the DOM.
 */
// eslint-disable-next-line react/display-name
const MockResolver = exports.MockResolver = /*#__PURE__*/_react.default.memo(props => {
  const [resolverElement, setResolverElement] = (0, _react.useState)(null);

  // Get a ref to the underlying Resolver element so we can resize.
  // Use a callback function because the underlying DOM node can change. In fact, `enzyme` seems to change it a lot.
  const resolverRef = (0, _react.useCallback)(element => {
    setResolverElement(element);
  }, []);

  // Resize the Resolver element to match the passed in props. Resolver is size dependent.
  (0, _react.useEffect)(() => {
    if (resolverElement) {
      var _props$rasterWidth, _props$rasterHeight;
      const size = {
        width: (_props$rasterWidth = props.rasterWidth) !== null && _props$rasterWidth !== void 0 ? _props$rasterWidth : 1600,
        height: (_props$rasterHeight = props.rasterHeight) !== null && _props$rasterHeight !== void 0 ? _props$rasterHeight : 1200,
        x: 0,
        y: 0,
        bottom: 0,
        left: 0,
        top: 0,
        right: 0,
        toJSON() {
          return this;
        }
      };
      props.sideEffectSimulator.controls.simulateElementResize(resolverElement, size);
    }
  }, [props.rasterWidth, props.rasterHeight, props.sideEffectSimulator.controls, resolverElement]);
  return /*#__PURE__*/_react.default.createElement(_mock.TestProviders, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: props.history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: props.coreStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_side_effect_context.SideEffectContext.Provider, {
    value: props.sideEffectSimulator.mock,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: props.store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_resolver_without_providers.ResolverWithoutProviders, {
    ref: resolverRef,
    databaseDocumentID: props.databaseDocumentID,
    resolverComponentInstanceID: props.resolverComponentInstanceID,
    indices: props.indices,
    shouldUpdate: props.shouldUpdate,
    filters: props.filters,
    isSplitPanel: props.isSplitPanel,
    showPanelOnClick: props.showPanelOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 17
    }
  })))))));
});