"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _keys = require("@kbn/security-solution-features/keys");
var _product_features_keys = require("@kbn/security-solution-features/src/product_features_keys");
var _lazy_cloud_security_posture_pli_auth_block_extension = require("./cloud_security_posture/lazy_cloud_security_posture_pli_auth_block_extension");
var _lazy_endpoint_agent_tamper_protection_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_agent_tamper_protection_extension");
var _translations = require("./common/translations");
var _constants = require("../common/constants");
var _application_links_updater = require("./app/links/application_links_updater");
var _lazy_endpoint_policy_edit_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_edit_extension");
var _lazy_endpoint_policy_create_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_extension");
var _lazy_endpoint_policy_create_multi_step_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_multi_step_extension");
var _lazy_endpoint_package_custom_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_package_custom_extension");
var _lazy_endpoint_policy_response_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_response_extension");
var _lazy_endpoint_generic_errors_list = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_generic_errors_list");
var _experimental_features = require("../common/experimental_features");
var _lazy_endpoint_custom_assets_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_custom_assets_extension");
var _lazy_asset_inventory_replacestep_extension = require("./asset_inventory/components/fleet_extensions/lazy_asset_inventory_replacestep_extension");
var _lazy_custom_cribl_extension = require("./security_integrations/cribl/components/lazy_custom_cribl_extension");
var _plugin_contract = require("./plugin_contract");
var _plugin_services = require("./plugin_services");
var _external_reference = require("./cases/attachments/external_reference");
var _helpers_access = require("./helpers_access");
var _attachments = require("./threat_intelligence/modules/cases/utils/attachments");
var _default_deep_links = require("./app/links/default_deep_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Plugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "storage", new _public2.Storage(localStorage));
    // Lazily instantiated dependencies
    (0, _defineProperty2.default)(this, "_subPlugins", void 0);
    (0, _defineProperty2.default)(this, "_store", void 0);
    (0, _defineProperty2.default)(this, "_actionsRegistered", false);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []).features;
    this.contract = new _plugin_contract.PluginContract(this.experimentalFeatures);
    this.services = new _plugin_services.PluginServices(this.config, this.experimentalFeatures, this.contract, initializerContext.env.packageInfo);
  }
  setup(core, plugins) {
    var _cases$attachmentFram;
    this.services.setup(core, plugins);
    const {
      home,
      usageCollection,
      management,
      cases
    } = plugins;
    const {
      productFeatureKeys$
    } = this.contract;

    // Lazily instantiate subPlugins and initialize services
    const mountDependencies = async params => {
      const {
        renderApp
      } = await this.lazyApplicationDependencies();
      const [coreStart, startPlugins] = await core.getStartServices();
      const subPlugins = await this.startSubPlugins(this.storage, coreStart, startPlugins);
      const store = await this.store(coreStart, startPlugins, subPlugins);
      const services = await this.services.generateServices(coreStart, startPlugins, params);
      return {
        renderApp,
        subPlugins,
        store,
        services
      };
    };

    // register cloud security ui metrics
    if (plugins.usageCollection) _ui_metrics.uiMetricService.setup(plugins.usageCollection);

    // Register main Security Solution plugin
    core.application.register({
      id: _constants.APP_UI_ID,
      title: _translations.SOLUTION_NAME,
      appRoute: _constants.APP_PATH,
      category: _public.DEFAULT_APP_CATEGORIES.security,
      deepLinks: _default_deep_links.defaultDeepLinks,
      updater$: this.appUpdater$,
      visibleIn: ['globalSearch', 'home', 'kibanaOverview'],
      euiIconType: _constants.APP_ICON_SOLUTION,
      mount: async params => {
        const {
          renderApp,
          services,
          store,
          subPlugins
        } = await mountDependencies(params);
        const {
          getSubPluginRoutesByCapabilities
        } = await this.lazyHelpersForRoutes();
        await this.registerActions(store, params.history, core, services);
        const subPluginRoutes = getSubPluginRoutesByCapabilities(subPlugins, services);
        const unmountApp = renderApp({
          ...params,
          services,
          store,
          usageCollection,
          subPluginRoutes
        });
        return () => {
          unmountApp();
        };
      }
    });

    // Register legacy SIEM app for backward compatibility
    core.application.register({
      id: 'siem',
      appRoute: 'app/siem',
      title: 'SIEM',
      visibleIn: [],
      mount: async _params => {
        const [coreStart] = await core.getStartServices();
        const {
          manageOldSiemRoutes
        } = await this.lazyHelpersForRoutes();
        const subscription = this.appUpdater$.subscribe(() => {
          // wait for app initialization to set the links
          manageOldSiemRoutes(coreStart);
          subscription.unsubscribe();
        });
        return () => true;
      }
    });
    home === null || home === void 0 ? void 0 : home.featureCatalogue.registerSolution({
      id: _constants.APP_ID,
      title: _translations.SOLUTION_NAME,
      description: _i18n.i18n.translate('xpack.securitySolution.featureCatalogueDescription', {
        defaultMessage: 'Prevent, collect, detect, and respond to threats for unified protection across your infrastructure.'
      }),
      icon: 'logoSecurity',
      path: _constants.APP_PATH,
      order: 300
    });
    home === null || home === void 0 ? void 0 : home.featureCatalogue.register({
      id: 'ai_assistant_security',
      title: _translations.ASSISTANT_MANAGEMENT_TITLE,
      description: _i18n.i18n.translate('xpack.securitySolution.securityAiAssistantManagement.app.description', {
        defaultMessage: 'Manage your AI Assistant for Security.'
      }),
      icon: 'sparkles',
      path: '/app/management/ai/securityAiAssistantManagement',
      showOnHomePage: false,
      category: 'admin'
    });
    management === null || management === void 0 ? void 0 : management.sections.section.ai.registerApp({
      id: 'securityAiAssistantManagement',
      title: _translations.ASSISTANT_MANAGEMENT_TITLE,
      hideFromSidebar: true,
      order: 1,
      mount: async params => {
        const {
          renderApp,
          services,
          store
        } = await mountDependencies();
        const {
          ManagementSettings
        } = await this.lazyAssistantSettingsManagement();
        return renderApp({
          ...params,
          services,
          store,
          usageCollection,
          children: /*#__PURE__*/_react.default.createElement(ManagementSettings, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 216,
              columnNumber: 21
            }
          })
        });
      }
    });
    productFeatureKeys$.pipe((0, _rxjs.combineLatestWith)(plugins.licensing.license$)).subscribe(([productFeatureKeys, license]) => {
      if (!productFeatureKeys || !license) {
        return;
      }
      const shouldShowAssistantManagement = (productFeatureKeys === null || productFeatureKeys === void 0 ? void 0 : productFeatureKeys.has(_product_features_keys.ProductFeatureAssistantKey.assistant)) && !(productFeatureKeys !== null && productFeatureKeys !== void 0 && productFeatureKeys.has(_keys.ProductFeatureSecurityKey.configurations)) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise'));
      const assistantManagementApp = management === null || management === void 0 ? void 0 : management.sections.section.ai.getApp('securityAiAssistantManagement');
      if (!shouldShowAssistantManagement) {
        assistantManagementApp === null || assistantManagementApp === void 0 ? void 0 : assistantManagementApp.disable();
      }
    });
    cases === null || cases === void 0 ? void 0 : cases.attachmentFramework.registerExternalReference((0, _external_reference.getExternalReferenceAttachmentEndpointRegular)());
    const externalAttachmentType = (0, _attachments.generateAttachmentType)();
    cases === null || cases === void 0 ? void 0 : (_cases$attachmentFram = cases.attachmentFramework) === null || _cases$attachmentFram === void 0 ? void 0 : _cases$attachmentFram.registerExternalReference(externalAttachmentType);
    this.registerDiscoverSharedFeatures(plugins);
    return this.contract.getSetupContract();
  }
  start(core, plugins) {
    this.services.start(core, plugins);
    this.registerFleetExtensions(core, plugins);
    this.registerPluginUpdates(core, plugins); // Not awaiting to prevent blocking start execution
    return this.contract.getStartContract(core);
  }
  stop() {
    this.services.stop();
  }
  async registerDiscoverSharedFeatures(plugins) {
    const {
      discoverShared
    } = plugins;
    const discoverFeatureRegistry = discoverShared.features.registry;
    const cellRendererFeature = {
      id: 'security-solution-cell-renderer',
      getRenderer: async () => {
        const {
          getCellRendererForGivenRecord
        } = await this.getLazyDiscoverSharedDeps();
        return getCellRendererForGivenRecord;
      }
    };
    discoverFeatureRegistry.register(cellRendererFeature);
  }
  async getLazyDiscoverSharedDeps() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "one_discover_shared_deps" */
    './one_discover')));
  }

  /**
   * SubPlugins are the individual building blocks of the Security Solution plugin.
   * They are lazily instantiated to improve startup time.
   * TODO: Move these functions to ./lazy_sub_plugins.ts
   */
  async createSubPlugins() {
    if (!this._subPlugins) {
      const {
        subPluginClasses
      } = await this.lazySubPlugins();
      this._subPlugins = {
        alerts: new subPluginClasses.Detections(),
        assetInventory: new subPluginClasses.AssetInventory(),
        attackDiscovery: new subPluginClasses.AttackDiscovery(),
        rules: new subPluginClasses.Rules(),
        exceptions: new subPluginClasses.Exceptions(),
        cases: new subPluginClasses.Cases(),
        dashboards: new subPluginClasses.Dashboards(),
        explore: new subPluginClasses.Explore(),
        onboarding: new subPluginClasses.Onboarding(),
        overview: new subPluginClasses.Overview(),
        timelines: new subPluginClasses.Timelines(),
        management: new subPluginClasses.Management(),
        cloudSecurityPosture: new subPluginClasses.CloudSecurityPosture(),
        threatIntelligence: new subPluginClasses.ThreatIntelligence(),
        entityAnalytics: new subPluginClasses.EntityAnalytics(),
        siemMigrations: new subPluginClasses.SiemMigrations(),
        siemReadiness: new subPluginClasses.SiemReadiness(),
        configurations: new subPluginClasses.Configurations(),
        reports: new subPluginClasses.Reports()
      };
    }
    return this._subPlugins;
  }
  async startSubPlugins(storage, core, plugins) {
    const subPlugins = await this.createSubPlugins();
    const alerts = await subPlugins.alerts.start(storage, plugins);
    return {
      alerts,
      assetInventory: subPlugins.assetInventory.start(),
      attackDiscovery: subPlugins.attackDiscovery.start(),
      cases: subPlugins.cases.start(),
      cloudSecurityPosture: subPlugins.cloudSecurityPosture.start(),
      dashboards: subPlugins.dashboards.start(),
      exceptions: subPlugins.exceptions.start(storage),
      explore: subPlugins.explore.start(storage),
      management: subPlugins.management.start(core, plugins),
      onboarding: subPlugins.onboarding.start(),
      overview: subPlugins.overview.start(),
      rules: subPlugins.rules.start(storage),
      threatIntelligence: subPlugins.threatIntelligence.start(),
      timelines: subPlugins.timelines.start(),
      entityAnalytics: subPlugins.entityAnalytics.start(this.experimentalFeatures.riskScoringRoutesEnabled),
      siemMigrations: subPlugins.siemMigrations.start(this.experimentalFeatures),
      siemReadiness: subPlugins.siemReadiness.start(),
      configurations: subPlugins.configurations.start(),
      reports: subPlugins.reports.start()
    };
  }

  /**
   * Lazily instantiate a `SecurityAppStore`. We lazily instantiate this because it requests large dynamic imports. We instantiate it once because each subPlugin needs to share the same reference.
   */
  async store(coreStart, startPlugins, subPlugins) {
    if (!this._store) {
      const {
        createStoreFactory
      } = await this.lazyApplicationDependencies();
      this._store = await createStoreFactory(coreStart, startPlugins, subPlugins, this.storage, this.experimentalFeatures);
    }
    if (startPlugins.timelines) {
      startPlugins.timelines.setTimelineEmbeddedStore(this._store);
    }
    return this._store;
  }
  async registerActions(store, history, coreSetup, services) {
    if (!this._actionsRegistered) {
      const {
        registerActions
      } = await this.lazyActions();
      await registerActions(store, history, coreSetup, services);
      this._actionsRegistered = true;
    }
  }

  /**
   * Registers the plugin updates including status, visibleIn, and deepLinks via the plugin updater$.
   */
  async registerPluginUpdates(core, plugins) {
    const {
      license$
    } = plugins.licensing;
    const {
      capabilities
    } = core.application;
    const {
      upsellingService,
      solutionNavigationTree$
    } = this.contract;

    // When the user does not have any of the capabilities required to access security solution, the plugin should be inaccessible
    // This is necessary to hide security solution from the selectable solutions in the spaces UI
    if (!(0, _helpers_access.isSecuritySolutionAccessible)(capabilities)) {
      this.appUpdater$.next(() => ({
        status: _public.AppStatus.inaccessible,
        visibleIn: []
      }));
      // no need to register the links updater when the plugin is inaccessible. return early
      return;
    }

    // Configuration of AppLinks updater registration based on license and capabilities
    const {
      appLinks: initialAppLinks,
      getFilteredLinks,
      registerDeepLinksUpdater
    } = await this.lazyApplicationLinks();
    registerDeepLinksUpdater(this.appUpdater$, solutionNavigationTree$);
    const appLinksToUpdate$ = new _rxjs.BehaviorSubject(initialAppLinks);
    appLinksToUpdate$.pipe((0, _rxjs.combineLatestWith)(license$)).subscribe(([appLinks, license]) => {
      const params = {
        experimentalFeatures: this.experimentalFeatures,
        upselling: upsellingService,
        capabilities,
        uiSettingsClient: core.uiSettings,
        ...(license.type != null && {
          license
        })
      };
      _application_links_updater.applicationLinksUpdater.update(appLinks, params);
    });
    const filteredLinks = await getFilteredLinks(core, plugins);
    appLinksToUpdate$.next(filteredLinks);
  }
  registerFleetExtensions(core, plugins) {
    if (!plugins.fleet) {
      return;
    }
    const {
      registerExtension
    } = plugins.fleet;
    const registerOptions = {
      coreStart: core,
      depsStart: plugins,
      services: {
        upsellingService: this.contract.upsellingService
      }
    };
    registerExtension({
      package: 'cloud_asset_inventory',
      view: 'package-policy-replace-define-step',
      Component: _lazy_asset_inventory_replacestep_extension.LazyAssetInventoryReplaceDefineStepExtension
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-policy-edit',
      Component: (0, _lazy_endpoint_policy_edit_extension.getLazyEndpointPolicyEditExtension)(registerOptions)
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-policy-response',
      Component: (0, _lazy_endpoint_policy_response_extension.getLazyEndpointPolicyResponseExtension)(registerOptions)
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-generic-errors-list',
      Component: (0, _lazy_endpoint_generic_errors_list.getLazyEndpointGenericErrorsListExtension)(registerOptions)
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-policy-create',
      Component: (0, _lazy_endpoint_policy_create_extension.getLazyEndpointPolicyCreateExtension)(registerOptions)
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-policy-create-multi-step',
      Component: _lazy_endpoint_policy_create_multi_step_extension.LazyEndpointPolicyCreateMultiStepExtension
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-detail-custom',
      Component: (0, _lazy_endpoint_package_custom_extension.getLazyEndpointPackageCustomExtension)(registerOptions)
    });
    registerExtension({
      package: 'endpoint',
      view: 'package-detail-assets',
      Component: _lazy_endpoint_custom_assets_extension.LazyEndpointCustomAssetsExtension
    });
    registerExtension({
      package: 'endpoint',
      view: 'endpoint-agent-tamper-protection',
      Component: (0, _lazy_endpoint_agent_tamper_protection_extension.getLazyEndpointAgentTamperProtectionExtension)(registerOptions)
    });
    registerExtension({
      package: 'cloud_security_posture',
      view: 'pli-auth-block',
      Component: (0, _lazy_cloud_security_posture_pli_auth_block_extension.getLazyCloudSecurityPosturePliAuthBlockExtension)(registerOptions)
    });
    registerExtension({
      package: 'cribl',
      view: 'package-policy-replace-define-step',
      Component: _lazy_custom_cribl_extension.LazyCustomCriblExtension
    });
  }

  // Lazy loaded dependencies

  lazyHelpersForRoutes() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazyHelpersForRoutes" */
    './helpers')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazyApplicationDependencies() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_application_dependencies" */
    './lazy_application_dependencies')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazySubPlugins() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_sub_plugins" */
    './lazy_sub_plugins')));
  }
  lazyApplicationLinks() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_app_links" */
    './app/links')));
  }
  lazyActions() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_actions" */
    './lazy_actions')));
  }
  lazyAssistantSettingsManagement() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_assistant_settings_management" */
    './lazy_assistant_settings_management')));
  }
}
exports.Plugin = Plugin;