"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InnerLinkPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/link_panel/inner_link_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ButtonContainer = (0, _styled.default)(_eui.EuiFlexGroup)`
  padding: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.s};
`;
const Icon = (0, _styled.default)(_eui.EuiIcon)`
  padding: 0;
  margin-top: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
  margin-left: 12px;
  transform: scale(${({
  color
}) => color === 'primary' ? 1.4 : 1});
`;
const PanelContainer = (0, _styled.default)(_eui.EuiSplitPanel.Inner)`
  margin-bottom: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
`;
const Title = (0, _styled.default)(_eui.EuiText)`
  color: ${({
  theme: {
    euiTheme
  },
  textcolor
}) => textcolor === 'primary' ? euiTheme.colors.primary : euiTheme.colors.textWarning};
  margin-bottom: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
`;
const InnerLinkPanel = ({
  body,
  button,
  color,
  dataTestSubj,
  learnMoreLink,
  title
}) => /*#__PURE__*/_react.default.createElement(PanelContainer, {
  grow: false,
  color: color,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  "data-test-subj": dataTestSubj,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(Icon, {
  type: color === 'primary' ? 'info' : 'help',
  size: "m",
  color: color,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 11
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(Title, {
  "data-test-subj": "inner-link-panel-title",
  textcolor: color,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 13
  }
}, title))), /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 9
  }
}, body, ' ', learnMoreLink && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: learnMoreLink,
  target: "_blank",
  "data-test-subj": `${dataTestSubj}-learn-more`,
  external: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 13
  }
}, i18n.LEARN_MORE))), button && /*#__PURE__*/_react.default.createElement(ButtonContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 11
  }
}, button))));
exports.InnerLinkPanel = InnerLinkPanel;
InnerLinkPanel.displayName = 'InnerLinkPanel';