"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../../app/types");
var _formatted_date = require("../../../../common/components/formatted_date");
var _formatted_number = require("../../../../common/components/formatted_number");
var _header_section = require("../../../../common/components/header_section");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _links = require("../../../../common/components/links");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("../translations"));
var _status_badge = require("./status_badge");
var _use_case_items = require("./use_case_items");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/cases_table/cases_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETECTION_RESPONSE_RECENT_CASES_QUERY_ID = 'recentlyCreatedCasesQuery';
const CasesTable = exports.CasesTable = /*#__PURE__*/_react.default.memo(() => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTION_RESPONSE_RECENT_CASES_QUERY_ID);
  const {
    items,
    isLoading,
    updatedAt
  } = (0, _use_case_items.useCaseItems)({
    skip: !toggleStatus
  });
  const navigateToCases = (0, _react.useCallback)(() => {
    navigateTo({
      deepLinkId: _types.SecurityPageName.case
    });
  }, [navigateTo]);
  const columns = (0, _react.useMemo)(() => getTableColumns({
    getAppUrl,
    navigateTo
  }), [getAppUrl, navigateTo]);
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "recentlyCreatedCasesPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: DETECTION_RESPONSE_RECENT_CASES_QUERY_ID,
    title: i18n.CASES_TABLE_SECTION_TITLE,
    titleSize: "s",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 21
      }
    }),
    showInspectButton: false,
    tooltip: i18n.CASES_TABLE_SECTION_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "recentlyCreatedCasesTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 40
        }
      }, i18n.NO_CASES_FOUND),
      titleSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "allCasesButton",
    onClick: navigateToCases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, i18n.VIEW_ALL_CASES))));
});
CasesTable.displayName = 'CasesTable';
const getTableColumns = () => [{
  field: 'id',
  name: i18n.CASES_TABLE_COLUMN_NAME,
  'data-test-subj': 'recentlyCreatedCaseName',
  render: (id, {
    name
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: i18n.OPEN_CASE_DETAIL_TOOLTIP,
    content: name,
    anchorClassName: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, name))
}, {
  field: 'totalAlerts',
  name: i18n.ALERTS_TEXT,
  truncateText: true,
  textOnly: true,
  'data-test-subj': 'recentlyCreatedCaseAlert',
  render: totalAlerts => /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 38
    }
  })
}, {
  field: 'createdAt',
  name: i18n.CASES_TABLE_COLUMN_TIME,
  render: createdAt => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    fieldName: i18n.CASES_TABLE_COLUMN_TIME,
    value: createdAt,
    className: "eui-textTruncate",
    dateFormat: "MMMM D, YYYY",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }),
  'data-test-subj': 'recentlyCreatedCaseTime'
}, {
  field: 'createdBy',
  name: i18n.CASES_TABLE_COLUMN_CREATED_BY,
  render: createdBy => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "recentlyCreatedCaseCreatedBy",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, createdBy)
}, {
  field: 'status',
  name: i18n.CASES_TABLE_COLUMN_STATUS,
  render: status => /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
    status: status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 39
    }
  }),
  'data-test-subj': 'recentlyCreatedCaseStatus'
}];