"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TeammatesCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("../../constants");
var _use_onboarding_service = require("../../../hooks/use_onboarding_service");
var _link_card = require("../common/link_card");
var _teammates_card = _interopRequireDefault(require("./images/teammates_card.png"));
var _teammates_card_dark = _interopRequireDefault(require("./images/teammates_card_dark.png"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_header/cards/teammates_card/teammates_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TeammatesCard = exports.TeammatesCard = /*#__PURE__*/_react.default.memo(({
  isDarkMode
}) => {
  const {
    usersUrl$
  } = (0, _use_onboarding_service.useOnboardingService)();
  const usersUrl = (0, _useObservable.default)(usersUrl$, undefined);
  return /*#__PURE__*/_react.default.createElement(_link_card.LinkCard, {
    id: _constants.OnboardingHeaderCardId.teammates,
    icon: isDarkMode ? _teammates_card_dark.default : _teammates_card.default,
    title: i18n.ONBOARDING_HEADER_TEAMMATES_TITLE,
    description: i18n.ONBOARDING_HEADER_TEAMMATES_DESCRIPTION,
    href: usersUrl,
    target: "_blank",
    linkText: i18n.ONBOARDING_HEADER_TEAMMATES_LINK_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
});
TeammatesCard.displayName = 'TeammatesCard';