"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadRulesSectionPanel = exports.UploadRulesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../../../../../../../siem_migrations/common/components");
var _upload_panel = require("../../../../../../../siem_migrations/common/styles/upload_panel.styles");
var _styles = require("../../../../../../../siem_migrations/common/styles");
var _kibana_react = require("../../../../../../../common/lib/kibana/kibana_react");
var _icon = require("../../../../../../../siem_migrations/common/icon");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/siem_migrations/start_migration/rules/upload_rules_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UploadRulesSectionPanel = exports.UploadRulesSectionPanel = /*#__PURE__*/_react.default.memo(function UploadRulesSectionPanel({
  isUploadMore = false,
  isDisabled = false,
  onOpenFlyout
}) {
  const styles = (0, _upload_panel.useUploadPanelStyles)(isUploadMore);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: isUploadMore ? 'm' : 'l',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    className: styles,
    gutterSize: isUploadMore ? 'm' : 'l',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_icon.SiemMigrationsIcon, {
    className: "siemMigrationsIcon",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, isUploadMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: _styles.START_MIGRATION_TITLE_CLASS_NAME,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 17
    }
  }, i18n.START_MIGRATION_CARD_UPLOAD_MORE_TITLE)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    className: _styles.START_MIGRATION_TITLE_CLASS_NAME,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 21
    }
  }, i18n.START_MIGRATION_CARD_UPLOAD_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 21
    }
  }, i18n.START_MIGRATION_CARD_UPLOAD_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_components.MigrationsReadMore, {
    migrationType: "rule",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, isUploadMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "startMigrationUploadMoreButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }, i18n.START_MIGRATION_CARD_UPLOAD_MORE_BUTTON) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "startMigrationUploadRulesButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, i18n.START_MIGRATION_CARD_UPLOAD_BUTTON))));
});
const UploadRulesPanel = exports.UploadRulesPanel = /*#__PURE__*/_react.default.memo(function UploadRulesPanel({
  isUploadMore = false,
  isDisabled = false
}) {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.rules;
  const {
    openFlyout
  } = (0, _components.useMigrationDataInputContext)();
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout();
    telemetry.reportSetupMigrationOpen({
      isFirstMigration: !isUploadMore
    });
  }, [openFlyout, telemetry, isUploadMore]);
  return /*#__PURE__*/_react.default.createElement(UploadRulesSectionPanel, {
    isDisabled: isDisabled,
    isUploadMore: isUploadMore,
    onOpenFlyout: onOpenFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  });
});
UploadRulesPanel.displayName = 'UploadRulesPanel';