"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SecurityMigrationIntegrations = exports.IntegrationsCard = exports.DEFAULT_CHECK_COMPLETE_METADATA = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _centered_loading_spinner = require("../../../../../../common/components/centered_loading_spinner");
var _integration_context = require("../../../../../../common/lib/integrations/hooks/integration_context");
var _integration_tabs_configs = require("../../../../../../common/lib/integrations/configs/integration_tabs_configs");
var _security_integrations_grid_tabs = require("../../../../../../common/lib/integrations/components/security_integrations_grid_tabs");
var _use_integration_card_list = require("../../../../../../common/lib/integrations/hooks/use_integration_card_list");
var _with_available_packages = require("../../../../../../common/lib/integrations/components/with_available_packages");
var _onboarding_context = require("../../../../onboarding_context");
var _card_content_panel = require("../../common/card_content_panel");
var _integration_card_top_callout = require("../../common/integrations/callouts/integration_card_top_callout");
var _use_get_integrations_stats = require("../../../../../../siem_migrations/rules/service/hooks/use_get_integrations_stats");
var _constants = require("../../../../../constants");
var _missing_migration_callout = require("./missing_migration_callout");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_selected_tab = require("../../../../../../common/lib/integrations/hooks/use_selected_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/siem_migrations/integrations/integrations_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_CHECK_COMPLETE_METADATA = exports.DEFAULT_CHECK_COMPLETE_METADATA = {
  activeIntegrations: [],
  isAgentRequired: false
};
const SecurityMigrationIntegrations = exports.SecurityMigrationIntegrations = (0, _with_available_packages.withAvailablePackages)(({
  availablePackages,
  checkCompleteMetadata = DEFAULT_CHECK_COMPLETE_METADATA,
  integrationsStats,
  topCalloutRenderer
}) => {
  var _activeIntegrations$l;
  const {
    isAgentRequired,
    activeIntegrations
  } = checkCompleteMetadata;
  const activeIntegrationsCount = (_activeIntegrations$l = activeIntegrations === null || activeIntegrations === void 0 ? void 0 : activeIntegrations.length) !== null && _activeIntegrations$l !== void 0 ? _activeIntegrations$l : 0;
  const {
    selectedTab,
    setSelectedTabId
  } = (0, _use_selected_tab.useSelectedTab)();
  const list = (0, _use_integration_card_list.useIntegrationCardList)({
    integrationsList: availablePackages.filteredCards,
    activeIntegrations,
    selectedTab
  });

  // Create the integrations list using integrationStats which is already sorted by total rules
  const integrationList = (0, _react.useMemo)(() => {
    if (!(integrationsStats !== null && integrationsStats !== void 0 && integrationsStats.length)) {
      return list;
    }
    const indexedStats = Object.fromEntries(integrationsStats.map(stats => [stats.id, stats.total_rules]));
    // Process the list to include only the cards that have integrations stats and set the title badge
    // Use indexedStats to keep O(n) complexity
    const indexedCards = list.reduce((acc, card) => {
      const totalRules = indexedStats[card.id];
      if (!totalRules) {
        return acc;
      }
      const titleBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 28
        }
      }, i18n.TOTAL_RULES(totalRules));
      acc[card.id] = {
        ...card,
        titleBadge
      };
      return acc;
    }, {});

    // Use the same order as the integrationsStats (descending by total rules from API)
    return integrationsStats.reduce((acc, {
      id
    }) => {
      const card = indexedCards[id];
      if (card) {
        acc.push(card);
      }
      return acc;
    }, []);
  }, [list, integrationsStats]);
  return /*#__PURE__*/_react.default.createElement(_security_integrations_grid_tabs.SecurityIntegrationsGridTabs, {
    isAgentRequired: isAgentRequired,
    activeIntegrationsCount: activeIntegrationsCount,
    topCalloutRenderer: topCalloutRenderer,
    integrationList: integrationList,
    availablePackages: availablePackages,
    selectedTab: selectedTab,
    setSelectedTabId: setSelectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  });
});
const IntegrationsCard = exports.IntegrationsCard = /*#__PURE__*/_react.default.memo(({
  checkCompleteMetadata,
  isCardComplete,
  setExpandedCardId
}) => {
  const {
    spaceId,
    telemetry
  } = (0, _onboarding_context.useOnboardingContext)();
  const isMigrationsCardComplete = isCardComplete(_constants.OnboardingCardId.siemMigrationsRules);
  const expandMigrationsCard = (0, _react.useCallback)(() => {
    setExpandedCardId(_constants.OnboardingCardId.siemMigrationsRules);
  }, [setExpandedCardId]);
  const [integrationsStats, setIntegrationsStats] = (0, _react.useState)([]);
  const processIntegrationsStats = (0, _react.useCallback)(stats => {
    // Prefix IDs with 'epr:' to match the integration card IDs
    setIntegrationsStats(stats.map(stat => ({
      ...stat,
      id: `epr:${stat.id}`
    })));
  }, []);
  const {
    getIntegrationsStats,
    isLoading
  } = (0, _use_get_integrations_stats.useGetIntegrationsStats)(processIntegrationsStats);
  (0, _react.useEffect)(() => {
    // fetch integrations stats only if the migrations card is complete (al least one migration is complete),
    if (isMigrationsCardComplete) {
      getIntegrationsStats();
    }
  }, [getIntegrationsStats, isMigrationsCardComplete]);

  // Replace the static "recommended" tab by the dynamic "detected" tab, based on the migrations integrations stats
  const integrationTabs = (0, _react.useMemo)(() => {
    const [recommendedTab, ...rest] = _integration_tabs_configs.INTEGRATION_TABS;
    if (!(integrationsStats !== null && integrationsStats !== void 0 && integrationsStats.length)) {
      return [{
        ...recommendedTab,
        appendAutoImportCard: true,
        overflow: 'scroll'
      }, ...rest];
    }
    const featuredCardIds = integrationsStats.map(({
      id
    }) => id);
    return [{
      ...recommendedTab,
      label: i18n.DETECTED_TAB_LABEL,
      featuredCardIds,
      appendAutoImportCard: true,
      overflow: 'scroll'
    }, ...rest];
  }, [integrationsStats]);

  // Wrap the top callout renderer to include the missing migration callout
  const topCalloutRenderer = (0, _react.useCallback)(({
    activeIntegrationsCount,
    isAgentRequired,
    selectedTabId
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isMigrationsCardComplete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_migration_callout.MissingMigrationCallout, {
      onExpandMigrationsCard: expandMigrationsCard,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_integration_card_top_callout.IntegrationCardTopCallout, {
      activeIntegrationsCount: activeIntegrationsCount,
      isAgentRequired: isAgentRequired,
      selectedTabId: selectedTabId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }));
  }, [isMigrationsCardComplete, expandMigrationsCard]);
  if (!checkCompleteMetadata || isLoading) {
    return /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      "data-test-subj": "loadingInstalledIntegrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_context.IntegrationContextProvider, {
    spaceId: spaceId,
    reportLinkClick: telemetry.reportLinkClick,
    integrationTabs: integrationTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(SecurityMigrationIntegrations, {
    prereleaseIntegrationsEnabled: true // Rule migrations uses prerelease integrations
    ,
    integrationsStats: integrationsStats,
    checkCompleteMetadata: checkCompleteMetadata,
    topCalloutRenderer: topCalloutRenderer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  })));
});
IntegrationsCard.displayName = 'IntegrationsCard';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = IntegrationsCard;