"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsights = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _use_knowledge_base_status = require("@kbn/elastic-assistant/impl/assistant/api/knowledge_base/use_knowledge_base_status");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _workflow_insights = require("../../../../../../../../common/endpoint/types/workflow_insights");
var _use_experimental_features = require("../../../../../../../common/hooks/use_experimental_features");
var _use_fetch_insights = require("../../../hooks/insights/use_fetch_insights");
var _use_trigger_scan = require("../../../hooks/insights/use_trigger_scan");
var _use_fetch_ongoing_tasks = require("../../../hooks/insights/use_fetch_ongoing_tasks");
var _translations = require("../../../translations");
var _workflow_insights_results = require("./workflow_insights_results");
var _workflow_insights_scan = require("./workflow_insights_scan");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/insights/workflow_insights.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowInsights = exports.WorkflowInsights = /*#__PURE__*/_react.default.memo(({
  endpointId
}) => {
  const [isScanRunning, setIsScanRunning] = (0, _react.useState)(true);
  const [userTriggeredScan, setUserTriggeredScan] = (0, _react.useState)(false);
  const [insightGenerationFailures, setInsightGenerationFailures] = (0, _react.useState)(false);
  const [expectedCount, setExpectedCount] = (0, _react.useState)(null);
  const [expectedTimestamp, setExpectedTimestamp] = (0, _react.useState)(null);
  const onLatestScanSuccess = (0, _react.useCallback)((count, timestamp) => {
    if (count === 0) {
      setIsScanRunning(false);
    }
    setExpectedCount(count);
    setExpectedTimestamp(timestamp);
  }, []);
  const defendInsightsPolicyResponseFailureEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('defendInsightsPolicyResponseFailure');
  const {
    inferenceEnabled,
    http,
    assistantAvailability: {
      isAssistantEnabled
    }
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: kbStatus
  } = (0, _use_knowledge_base_status.useKnowledgeBaseStatus)({
    http,
    enabled: isAssistantEnabled
  });
  const onInsightGenerationFailure = () => {
    setInsightGenerationFailures(true);
  };
  const insightTypes = (0, _react.useMemo)(() => {
    const typesToQuery = [_elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus];
    if (defendInsightsPolicyResponseFailureEnabled && (
    // we only want to run `policy_response_failure` type with KB
    kbStatus !== null && kbStatus !== void 0 && kbStatus.defend_insights_exists || kbStatus !== null && kbStatus !== void 0 && kbStatus.is_setup_in_progress)) {
      typesToQuery.push(_elasticAssistantCommon.DefendInsightType.Enum.policy_response_failure);
    }
    return typesToQuery;
  }, [defendInsightsPolicyResponseFailureEnabled, kbStatus]);

  // refetch is automatically triggered when expectedCount changes
  const {
    data: insights
  } = (0, _use_fetch_insights.useFetchInsights)({
    endpointId,
    onSuccess: () => setIsScanRunning(false),
    scanCompleted: !isScanRunning,
    expectedCount,
    expectedTimestamp,
    insightTypes
  });
  const {
    refetch: refetchLatestScan
  } = (0, _use_fetch_ongoing_tasks.useFetchLatestScan)({
    endpointId,
    insightTypes,
    isPolling: isScanRunning,
    onSuccess: onLatestScanSuccess,
    onInsightGenerationFailure
  });
  const {
    mutate: triggerScan
  } = (0, _use_trigger_scan.useTriggerScan)({
    onSuccess: refetchLatestScan
  });
  (0, _react.useEffect)(() => {
    setExpectedCount(null);
    setExpectedTimestamp(null);
    setIsScanRunning(true);
    setUserTriggeredScan(false);
  }, [endpointId]);
  const lastResultCaption = (0, _react.useMemo)(() => {
    if (!(insights !== null && insights !== void 0 && insights.length)) {
      return null;
    }
    const latestTimestamp = insights.map(insight => _moment.default.utc(insight['@timestamp'])).sort((a, b) => b.diff(a))[0];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, `${_translations.WORKFLOW_INSIGHTS.titleRight} ${latestTimestamp.local().fromNow()}`);
  }, [insights]);
  const activeInsights = (0, _react.useMemo)(() => {
    if (isScanRunning) {
      return [];
    }
    const insightTypesSet = new Set(insightTypes);
    return (insights !== null && insights !== void 0 ? insights : []).filter(insight => insightTypesSet.has(insight.type) && insight.action.type === _workflow_insights.ActionType.Refreshed);
  }, [isScanRunning, insights, insightTypes]);
  const onScanButtonClick = (0, _react.useCallback)(({
    actionTypeId,
    connectorId
  }) => {
    if (insightGenerationFailures) {
      setInsightGenerationFailures(false);
    }
    setIsScanRunning(true);
    setExpectedCount(null);
    setExpectedTimestamp((0, _moment.default)());
    if (!userTriggeredScan) {
      setUserTriggeredScan(true);
    }
    triggerScan({
      endpointId,
      actionTypeId,
      connectorId,
      insightTypes
    });
  }, [insightGenerationFailures, userTriggeredScan, triggerScan, endpointId, insightTypes]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "endpointDetailsInsightsWrapper",
    gutterSize: 's',
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, _translations.WORKFLOW_INSIGHTS.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, lastResultCaption))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_workflow_insights_scan.WorkflowInsightsScanSection, {
    isScanButtonDisabled: isScanRunning,
    onScanButtonClick: onScanButtonClick,
    inferenceEnabled: inferenceEnabled,
    kbStatus: kbStatus,
    defendInsightsPolicyResponseFailureEnabled: defendInsightsPolicyResponseFailureEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_workflow_insights_results.WorkflowInsightsResults, {
    results: activeInsights,
    scanCompleted: !isScanRunning && !insightGenerationFailures && userTriggeredScan,
    endpointId: endpointId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }));
});
WorkflowInsights.displayName = 'WorkflowInsights';