"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEndpointPendingActionsSummary = void 0;
var _reactQuery = require("@kbn/react-query");
var _endpoint_pending_actions = require("../../../common/lib/endpoint/endpoint_pending_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves the pending actions against the given Endpoint `agent.id`'s
 * @param endpointAgentIds
 * @param options
 */
const useGetEndpointPendingActionsSummary = (endpointAgentIds, options = {}) => {
  return (0, _reactQuery.useQuery)({
    queryKey: ['fetch-endpoint-pending-actions-summary', ...endpointAgentIds],
    ...options,
    queryFn: () => (0, _endpoint_pending_actions.fetchPendingActionsByAgentId)(endpointAgentIds)
  });
};
exports.useGetEndpointPendingActionsSummary = useGetEndpointPendingActionsSummary;