"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponseWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../common/lib/kibana");
var _formatted_date = require("../../../common/components/formatted_date");
var _use_get_endpoint_policy_response = require("../../hooks/endpoint/use_get_endpoint_policy_response");
var _policy_response = require("./policy_response");
var _utils = require("../../pages/endpoint_hosts/store/utils");
var _policy_response_action_item = require("./policy_response_action_item");
var _policy_response_friendly_names = require("./policy_response_friendly_names");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/policy_response/policy_response_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyResponseWrapper = exports.PolicyResponseWrapper = /*#__PURE__*/(0, _react.memo)(({
  endpointId,
  showRevisionMessage = true,
  onShowNeedsAttentionBadge
}) => {
  var _data$policy_response, _data$policy_response2, _endpointDetails$meta;
  const {
    data,
    isLoading,
    isFetching,
    isError
  } = (0, _use_get_endpoint_policy_response.useGetEndpointPolicyResponse)(endpointId);
  const {
    data: endpointDetails
  } = (0, _hooks.useGetEndpointDetails)(endpointId);
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const [policyResponseConfig, setPolicyResponseConfig] = (0, _react.useState)();
  const [policyResponseArtifacts, setPolicyResponseArtifacts] = (0, _react.useState)();
  const [policyResponseActions, setPolicyResponseActions] = (0, _react.useState)();
  const [policyResponseAttentionCount, setPolicyResponseAttentionCount] = (0, _react.useState)(new Map());
  (0, _react.useEffect)(() => {
    if (!!data && !isLoading && !isFetching && !isError) {
      setPolicyResponseConfig(data.policy_response.Endpoint.policy.applied.response.configurations);
      setPolicyResponseArtifacts(data.policy_response.Endpoint.policy.applied.artifacts);
      setPolicyResponseActions(data.policy_response.Endpoint.policy.applied.actions);
      setPolicyResponseAttentionCount((0, _utils.getFailedOrWarningActionCountFromPolicyResponse)(data.policy_response.Endpoint.policy.applied));
    }
  }, [data, isLoading, isFetching, isError]);

  // This is needed for the `needs attention` action button in fleet. Will callback `true` if any error in policy response
  (0, _react.useEffect)(() => {
    if (onShowNeedsAttentionBadge) {
      for (const count of policyResponseAttentionCount.values()) {
        if (count) {
          // When an error has found, callback to true and return for loop exit
          onShowNeedsAttentionBadge(true);
          return;
        }
      }
    }
  }, [policyResponseAttentionCount, onShowNeedsAttentionBadge]);
  const genericErrors = (0, _react.useMemo)(() => {
    if (!policyResponseConfig && !policyResponseActions) {
      return [];
    }
    return policyResponseActions === null || policyResponseActions === void 0 ? void 0 : policyResponseActions.reduce((acc, currentAction) => {
      const policyResponseActionFormatter = new _policy_response_friendly_names.PolicyResponseActionFormatter(currentAction, docLinks.links.securitySolution.policyResponseTroubleshooting, endpointDetails === null || endpointDetails === void 0 ? void 0 : endpointDetails.metadata.host.os.name.toLowerCase());
      if (policyResponseActionFormatter.isGeneric && policyResponseActionFormatter.hasError) {
        acc.push(policyResponseActionFormatter);
      }
      return acc;
    }, []);
  }, [docLinks.links.securitySolution.policyResponseTroubleshooting, policyResponseActions, policyResponseConfig, endpointDetails === null || endpointDetails === void 0 ? void 0 : endpointDetails.metadata.host.os.name]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showRevisionMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "endpointPolicyResponseTimestamp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyResponse.appliedOn",
    defaultMessage: "Revision {rev} applied on {date}",
    values: {
      rev: (_data$policy_response = data === null || data === void 0 ? void 0 : data.policy_response.Endpoint.policy.applied.endpoint_policy_version) !== null && _data$policy_response !== void 0 ? _data$policy_response : '',
      date: /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDateFromPrimitive, {
        value: (_data$policy_response2 = data === null || data === void 0 ? void 0 : data.policy_response['@timestamp']) !== null && _data$policy_response2 !== void 0 ? _data$policy_response2 : '',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  })), isError && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.details.noPolicyResponse",
      defaultMessage: "No policy response available",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 23
    }
  }), policyResponseConfig !== undefined && policyResponseActions !== undefined && policyResponseArtifacts !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_response.PolicyResponse, {
    hostOs: (_endpointDetails$meta = endpointDetails === null || endpointDetails === void 0 ? void 0 : endpointDetails.metadata.host.os.name.toLowerCase()) !== null && _endpointDetails$meta !== void 0 ? _endpointDetails$meta : '',
    policyResponseConfig: policyResponseConfig,
    policyResponseActions: policyResponseActions,
    policyResponseArtifacts: policyResponseArtifacts,
    policyResponseAttentionCount: policyResponseAttentionCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }), genericErrors === null || genericErrors === void 0 ? void 0 : genericErrors.map(genericActionError => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: genericActionError.key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_response_action_item.PolicyResponseActionItem, {
    policyResponseActionFormatter: genericActionError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 19
    }
  })))));
});
PolicyResponseWrapper.displayName = 'PolicyResponse';