"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _policy_response_artifact_item = require("./policy_response_artifact_item");
var _kibana = require("../../../common/lib/kibana");
var _types = require("../../../../common/endpoint/types");
var _policy_response_friendly_names = require("./policy_response_friendly_names");
var _policy_response_action_item = require("./policy_response_action_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/policy_response/policy_response.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Most of them are needed in order to display large react nodes (PolicyResponseActionItem) in child levels.
const StyledEuiTreeView = (0, _styledComponents.default)(_eui.EuiTreeView)`
  & .policy-response-artifact-item {
    & .euiTreeView__nodeLabel {
      width: 100%;
    }
  }

  & .policy-response-action-item-expanded {
    height: auto;
    padding-top: ${({
  theme
}) => theme.eui.euiSizeS};
    padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};

    & .euiTreeView__nodeLabel {
      width: 100%;
      user-select: text;
      cursor: text;
    }
  }

  & .policyResponseStatusHealth {
    padding-top: 5px;
  }

  & .euiTreeView__node--expanded {
    max-height: none !important;

    & .policy-response-action-expanded + div {
      & .euiTreeView__node {
        // When response action item displays a callout, this needs to be overwritten to remove the default max height of EuiTreeView
        max-height: none !important;
      }
    }
  }

  & .euiTreeView__node {
    max-height: none !important;

    & .euiNotificationBadge {
      margin-right: 5px;
    }

    & .euiTreeView__nodeLabel {
      & .euiText {
        font-size: ${({
  theme
}) => theme.eui.euiFontSize};
        user-select: text;
        cursor: text;
      }
    }
  }
`;
/**
 * A policy response is returned by the endpoint and shown in the host details after a user modifies a policy
 */
const PolicyResponse = exports.PolicyResponse = /*#__PURE__*/(0, _react.memo)(({
  hostOs,
  policyResponseConfig,
  policyResponseActions,
  policyResponseArtifacts,
  policyResponseAttentionCount
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const getEntryIcon = (0, _react.useCallback)((status, unsuccessCounts) => status === _types.HostPolicyResponseActionStatus.success ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success",
    "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
    className: "policyResponseStatusHealth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }) : status === _types.HostPolicyResponseActionStatus.unsupported ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
    className: "policyResponseStatusHealth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    "data-test-subj": "endpointPolicyResponseStatusAttentionHealth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, unsuccessCounts), []);
  const getConcernedActions = (0, _react.useCallback)(concernedActions => {
    return concernedActions.map(actionKey => {
      const action = policyResponseActions.find(currentAction => currentAction.name === actionKey);
      const policyResponseActionFormatter = new _policy_response_friendly_names.PolicyResponseActionFormatter(action || {}, docLinks.links.securitySolution.policyResponseTroubleshooting, hostOs);
      return {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: action.status !== _types.HostPolicyResponseActionStatus.success && action.status !== _types.HostPolicyResponseActionStatus.unsupported ? 'danger' : 'default',
          "data-test-subj": "endpointPolicyResponseAction",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 15
          }
        }, policyResponseActionFormatter.title),
        id: actionKey,
        className: action.status !== _types.HostPolicyResponseActionStatus.success && action.status !== _types.HostPolicyResponseActionStatus.unsupported ? 'policy-response-action-expanded' : '',
        icon: getEntryIcon(action.status, action.status !== _types.HostPolicyResponseActionStatus.success ? 1 : 0),
        children: [{
          label: /*#__PURE__*/_react.default.createElement(_policy_response_action_item.PolicyResponseActionItem, {
            policyResponseActionFormatter: policyResponseActionFormatter,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 160,
              columnNumber: 19
            }
          }),
          id: `action_message_${actionKey}`,
          isExpanded: true,
          className: 'policy-response-action-item-expanded'
        }]
      };
    });
  }, [docLinks.links.securitySolution.policyResponseTroubleshooting, getEntryIcon, policyResponseActions, hostOs]);
  const getArtifacts = (0, _react.useCallback)(artifactIdentifiers => {
    return (artifactIdentifiers !== null && artifactIdentifiers !== void 0 ? artifactIdentifiers : []).map(artifact => {
      return {
        label: /*#__PURE__*/_react.default.createElement(_policy_response_artifact_item.PolicyResponseArtifactItem, {
          artifact: artifact,
          key: artifact.sha256,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 20
          }
        }),
        id: artifact.name,
        className: 'policy-response-artifact-item'
      };
    });
  }, []);
  const getResponseConfigs = (0, _react.useCallback)(() => {
    const config = Object.entries(policyResponseConfig).map(([key, val]) => {
      const attentionCount = policyResponseAttentionCount.get(key);
      return {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: attentionCount ? 'danger' : 'default',
          size: "s",
          "data-test-subj": "endpointPolicyResponseConfig",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 202,
            columnNumber: 13
          }
        }, (0, _policy_response_friendly_names.formatResponse)(key)),
        id: key,
        icon: attentionCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
          "data-test-subj": "endpointPolicyResponseStatusAttentionHealth",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 13
          }
        }, attentionCount) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: "success",
          "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
          className: "policyResponseStatusHealth",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 216,
            columnNumber: 13
          }
        }),
        children: getConcernedActions(val.concerned_actions)
      };
    });
    const artifacts = {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: 'default',
        size: "s",
        "data-test-subj": "endpointPolicyResponseArtifactsTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyResponse.artifacts.title",
        defaultMessage: "Artifacts",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 13
        }
      })),
      id: 'policyResponseArtifacts',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: "success",
        "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
        className: "policyResponseStatusHealth",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 11
        }
      }),
      children: Object.entries(policyResponseArtifacts).map(([key, val]) => {
        return {
          label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "default",
            size: "s",
            "data-test-subj": `endpointPolicyResponseArtifact${(0, _lodash.capitalize)(key)}`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 246,
              columnNumber: 15
            }
          }, `${(0, _lodash.capitalize)(key)}${val.version ? ` (v${val.version})` : ''}`),
          id: key,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
            color: "success",
            "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
            className: "policyResponseStatusHealth",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 256,
              columnNumber: 15
            }
          }),
          children: getArtifacts(val.identifiers)
        };
      })
    };
    return [...config, artifacts];
  }, [getArtifacts, getConcernedActions, policyResponseArtifacts, policyResponseAttentionCount, policyResponseConfig]);
  const generateTreeView = (0, _react.useCallback)(() => {
    let policyTotalErrors = 0;
    for (const count of policyResponseAttentionCount.values()) {
      policyTotalErrors += count;
    }
    return [{
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: policyTotalErrors ? 'danger' : 'default',
        size: "s",
        "data-test-subj": "endpointPolicyResponseTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 283,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyResponse.title",
        defaultMessage: "Policy Response",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 15
        }
      })),
      id: 'policyResponse',
      icon: policyTotalErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": "endpointPolicyResponseStatusHealth",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 13
        }
      }, policyTotalErrors) : undefined,
      children: getResponseConfigs()
    }];
  }, [getResponseConfigs, policyResponseAttentionCount]);
  const generatedTreeView = generateTreeView();
  return /*#__PURE__*/_react.default.createElement(StyledEuiTreeView, {
    items: generatedTreeView,
    showExpansionArrows: true,
    "aria-label": "policyResponseTreeView",
    "aria-labelledby": "policyResponseTreeView",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  });
});
PolicyResponse.displayName = 'PolicyResponse';