"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseRoute = exports.manageOldSiemRoutes = exports.isTourPath = exports.isTimelineScope = exports.isThreatIntelligencePath = exports.isSubPluginAvailable = exports.isInTableScope = exports.isDetectionsPath = exports.isDashboardViewPath = exports.isAlertsPageScope = exports.isActiveTimeline = exports.getSubPluginRoutesByCapabilities = exports.getSourcererScopeId = exports.getScopedActions = exports.getInspectResponse = exports.getFieldKey = exports.getField = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _lodash = require("lodash");
var _constants = require("../common/constants");
var _no_privileges = require("./common/components/no_privileges");
var _types = require("./app/types");
var _types2 = require("./types");
var _store = require("./timelines/store");
var _types3 = require("../common/types");
var _model = require("./sourcerer/store/model");
var _helpers_access = require("./helpers_access");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const parseRoute = location => {
  if (!(0, _fp.isEmpty)(location.hash)) {
    var _pageRoute$slice$join;
    const hashPath = location.hash.split('?');
    const search = hashPath.length >= 1 ? `?${hashPath[1]}` : '';
    const pageRoute = hashPath.length > 0 ? hashPath[0].split('/') : [];
    const pageName = pageRoute.length >= 1 ? pageRoute[1] : '';
    const path = `/${(_pageRoute$slice$join = pageRoute.slice(2).join('/')) !== null && _pageRoute$slice$join !== void 0 ? _pageRoute$slice$join : ''}${search}`;
    return {
      pageName,
      path,
      search
    };
  }
  const search = location.search;
  const pageRoute = location.pathname.split('/');
  const pageName = pageRoute[3];
  const subpluginPath = pageRoute.length > 4 ? `/${pageRoute.slice(4).join('/')}` : '';
  const path = `${subpluginPath}${search}`;
  return {
    pageName,
    path,
    search
  };
};
exports.parseRoute = parseRoute;
const manageOldSiemRoutes = async coreStart => {
  const {
    application
  } = coreStart;
  const {
    pageName,
    path
  } = parseRoute(window.location);
  switch (pageName) {
    case _types.SecurityPageName.overview:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.overview,
        replace: true,
        path
      });
      break;
    case 'ml-hosts':
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.hosts,
        replace: true,
        path: `/ml-hosts${path}`
      });
      break;
    case _types.SecurityPageName.hosts:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.hosts,
        replace: true,
        path
      });
      break;
    case 'ml-network':
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.network,
        replace: true,
        path: `/ml-network${path}`
      });
      break;
    case _types.SecurityPageName.network:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.network,
        replace: true,
        path
      });
      break;
    case _types.SecurityPageName.timelines:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.timelines,
        replace: true,
        path
      });
      break;
    case _types.SecurityPageName.case:
    case 'case':
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.case,
        replace: true,
        path
      });
      break;
    case _types.SecurityPageName.detections:
    case _types.SecurityPageName.alerts:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.alerts,
        replace: true,
        path
      });
      break;
    case _types.SecurityPageName.rules:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.rules,
        replace: true,
        path
      });
      break;
    case _types.SecurityPageName.exceptions:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.exceptions,
        replace: true,
        path
      });
      break;
    default:
      application.navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.landing,
        replace: true,
        path
      });
      break;
  }
};
exports.manageOldSiemRoutes = manageOldSiemRoutes;
const getInspectResponse = (response, prevResponse) => ({
  dsl: (0, _lodash.isObject)(response === null || response === void 0 ? void 0 : response.inspect) && response !== null && response !== void 0 && response.inspect.dsl ? response.inspect.dsl : (prevResponse === null || prevResponse === void 0 ? void 0 : prevResponse.dsl) || [],
  response: response != null ? [JSON.stringify(response.rawResponse, null, 2)] : prevResponse === null || prevResponse === void 0 ? void 0 : prevResponse.response
});
exports.getInspectResponse = getInspectResponse;
const isDetectionsPath = pathname => {
  return !!(0, _reactRouterDom.matchPath)(pathname, {
    path: `(${_constants.ALERTS_PATH}|${_constants.RULES_PATH}|${_constants.EXCEPTIONS_PATH})`,
    strict: false
  });
};
exports.isDetectionsPath = isDetectionsPath;
const isDashboardViewPath = pathname => (0, _reactRouterDom.matchPath)(pathname, {
  path: `${_constants.DASHBOARDS_PATH}/:detailName`,
  exact: false,
  strict: false
}) != null;
exports.isDashboardViewPath = isDashboardViewPath;
const isAlertsPath = pathname => {
  return !!(0, _reactRouterDom.matchPath)(pathname, {
    path: `${_constants.ALERTS_PATH}`,
    strict: false
  });
};
const isCaseDetailsPath = pathname => {
  return !!(0, _reactRouterDom.matchPath)(pathname, {
    path: `${_constants.CASES_PATH}/:detailName`,
    strict: false
  });
};
const isTourPath = pathname => isAlertsPath(pathname) || isCaseDetailsPath(pathname);
exports.isTourPath = isTourPath;
const isThreatIntelligencePath = pathname => {
  return !!(0, _reactRouterDom.matchPath)(pathname, {
    path: `(${_constants.THREAT_INTELLIGENCE_PATH})`,
    strict: false
  });
};
exports.isThreatIntelligencePath = isThreatIntelligencePath;
const getSubPluginRoutesByCapabilities = (subPlugins, services) => {
  return Object.entries(subPlugins).reduce((acc, [key, value]) => {
    if (isSubPluginAvailable(key, services.application.capabilities)) {
      acc.push(...value.routes);
    } else {
      const docLinkSelector = docLinks => docLinks.siem.privileges;
      acc.push(...value.routes.map(route => ({
        path: route.path,
        component: () => {
          const Upsell = services.upselling.getPageUpselling(key);
          if (Upsell) {
            return /*#__PURE__*/_react.default.createElement(Upsell, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 222,
                columnNumber: 22
              }
            });
          }
          return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
            pageName: key,
            docLinkSelector: docLinkSelector,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 224,
              columnNumber: 20
            }
          });
        }
      })));
    }
    return acc;
  }, []);
};
exports.getSubPluginRoutesByCapabilities = getSubPluginRoutesByCapabilities;
const isSubPluginAvailable = (pluginKey, capabilities) => {
  if (_types2.CASES_SUB_PLUGIN_KEY === pluginKey) {
    return capabilities[_constants.CASES_FEATURE_ID].read_cases === true;
  }
  return (0, _helpers_access.hasAccessToSecuritySolution)(capabilities);
};
exports.isSubPluginAvailable = isSubPluginAvailable;
const siemSignalsFieldMappings = {
  [_ruleDataUtils.ALERT_RULE_UUID]: 'signal.rule.id',
  [_ruleDataUtils.ALERT_RULE_NAME]: 'signal.rule.name',
  [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.filters`]: 'signal.rule.filters',
  [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.language`]: 'signal.rule.language',
  [`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.query`]: 'signal.rule.query'
};
const alertFieldMappings = {
  'signal.rule.id': _ruleDataUtils.ALERT_RULE_UUID,
  'signal.rule.name': _ruleDataUtils.ALERT_RULE_NAME,
  'signal.rule.filters': `${_ruleDataUtils.ALERT_RULE_PARAMETERS}.filters`,
  'signal.rule.language': `${_ruleDataUtils.ALERT_RULE_PARAMETERS}.language`,
  'signal.rule.query': `${_ruleDataUtils.ALERT_RULE_PARAMETERS}.query`
};

/*
 * Deprecation notice: This functionality should be removed when support for signal.* is no longer
 * supported.
 *
 * Selectively returns the AAD field key (kibana.alert.*) or the legacy field
 * (signal.*), whichever is present. For backwards compatibility.
 */
const getFieldKey = (ecsData, field) => {
  var _alertFieldMappings$f, _siemSignalsFieldMapp;
  const aadField = ((_alertFieldMappings$f = alertFieldMappings[field]) !== null && _alertFieldMappings$f !== void 0 ? _alertFieldMappings$f : field).replace('signal', 'kibana.alert');
  const siemSignalsField = ((_siemSignalsFieldMapp = siemSignalsFieldMappings[field]) !== null && _siemSignalsFieldMapp !== void 0 ? _siemSignalsFieldMapp : field).replace('kibana.alert', 'signal');
  if ((0, _fp.has)(aadField, ecsData)) return aadField;
  return siemSignalsField;
};

/*
 * Deprecation notice: This functionality should be removed when support for signal.* is no longer
 * supported.
 *
 * Selectively returns the AAD field value (kibana.alert.*) or the legacy field value
 * (signal.*), whichever is present. For backwards compatibility.
 */
exports.getFieldKey = getFieldKey;
const getField = (ecsData, field) => {
  var _alertFieldMappings$f2, _siemSignalsFieldMapp2, _get;
  const aadField = ((_alertFieldMappings$f2 = alertFieldMappings[field]) !== null && _alertFieldMappings$f2 !== void 0 ? _alertFieldMappings$f2 : field).replace('signal', 'kibana.alert');
  const siemSignalsField = ((_siemSignalsFieldMapp2 = siemSignalsFieldMappings[field]) !== null && _siemSignalsFieldMapp2 !== void 0 ? _siemSignalsFieldMapp2 : field).replace('kibana.alert', 'signal');
  const parts = aadField.split('.');
  if (parts.includes('parameters') && parts[parts.length - 1] !== 'parameters') {
    const paramsField = parts.slice(0, parts.length - 1).join('.');
    const params = (0, _fp.get)(paramsField, ecsData);
    const value = (0, _fp.get)(parts[parts.length - 1], params);
    return value;
  }
  const value = (_get = (0, _fp.get)(aadField, ecsData)) !== null && _get !== void 0 ? _get : (0, _fp.get)(siemSignalsField, ecsData);
  return value;
};
exports.getField = getField;
const isTimelineScope = scopeId => Object.values(_types3.TimelineId).includes(scopeId);
exports.isTimelineScope = isTimelineScope;
const isInTableScope = scopeId => Object.values(_securitysolutionDataTable.TableId).includes(scopeId);
exports.isInTableScope = isInTableScope;
const isAlertsPageScope = scopeId => [_securitysolutionDataTable.TableId.alertsOnAlertsPage, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage, _securitysolutionDataTable.TableId.alertsOnCasePage].includes(scopeId);
exports.isAlertsPageScope = isAlertsPageScope;
const getScopedActions = scopeId => {
  if (isTimelineScope(scopeId)) {
    return _store.timelineActions;
  } else if (isInTableScope(scopeId)) {
    return _securitysolutionDataTable.dataTableActions;
  }
};
exports.getScopedActions = getScopedActions;
const isActiveTimeline = timelineId => timelineId === _types3.TimelineId.active;
exports.isActiveTimeline = isActiveTimeline;
const getSourcererScopeId = scopeId => {
  if (isTimelineScope(scopeId)) {
    return _model.SourcererScopeName.timeline;
  } else if (isAlertsPageScope(scopeId)) {
    return _model.SourcererScopeName.detections;
  } else {
    return _model.SourcererScopeName.default;
  }
};
exports.getSourcererScopeId = getSourcererScopeId;