"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewPanelKey = exports.RulePanelKey = exports.RulePanel = exports.RULE_PREVIEW_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _content = require("./content");
var _header = require("./header");
var _footer = require("../preview/footer");
var _use_rule_details = require("../hooks/use_rule_details");
var _test_ids = require("./test_ids");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _flyout_error = require("../../shared/components/flyout_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/rule_details/right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulePanelKey = exports.RulePanelKey = 'rule-panel';
const RulePreviewPanelKey = exports.RulePreviewPanelKey = 'rule-preview-panel';
const RULE_PREVIEW_BANNER = exports.RULE_PREVIEW_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.rule.rulePreviewTitle', {
    defaultMessage: 'Preview rule details'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};
/**
 * Displays a rule overview panel
 */
const RulePanel = exports.RulePanel = /*#__PURE__*/(0, _react.memo)(({
  ruleId,
  isPreviewMode
}) => {
  const {
    rule,
    loading,
    isExistingRule
  } = (0, _use_rule_details.useRuleDetails)({
    ruleId
  });
  return loading ? /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
    "data-test-subj": _test_ids.LOADING_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }) : rule ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    isPreviewMode: isPreviewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    rule: rule,
    isSuppressed: !isExistingRule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    rule: rule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), isPreviewMode && /*#__PURE__*/_react.default.createElement(_footer.PreviewFooter, {
    ruleId: ruleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 25
    }
  })) : /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  });
});
RulePanel.displayName = 'RulePanel';