"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityTableColumns = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _default_renderer = require("../../../../../timelines/components/field_renderers/default_renderer");
var _empty_value = require("../../../../../common/components/empty_value");
var _link_utils = require("../../../../shared/utils/link_utils");
var _preview_link = require("../../../../shared/components/preview_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/shared/components/entity_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getEntityTableColumns = (contextID, scopeId, data) => [{
  name: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.fieldColumnTitle",
    defaultMessage: "Field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }),
  field: 'label',
  render: (label, {
    field
  }) => /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "entity-table-label",
    css: (0, _react.css)`
          font-weight: ${_uiTheme.euiThemeVars.euiFontWeightMedium};
          color: ${_uiTheme.euiThemeVars.euiTitleColor};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, label !== null && label !== void 0 ? label : field)
}, {
  name: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.valuesColumnTitle",
    defaultMessage: "Values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }),
  field: 'field',
  render: (field, {
    getValues,
    render,
    renderField
  }) => {
    const values = getValues && getValues(data);
    if (field) {
      const showPreviewLink = values && (0, _link_utils.isFlyoutLink)({
        field,
        scopeId
      });
      const renderPreviewLink = value => /*#__PURE__*/_react2.default.createElement(_preview_link.PreviewLink, {
        field: field,
        value: value,
        scopeId: scopeId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 11
        }
      });
      return /*#__PURE__*/_react2.default.createElement(_default_renderer.DefaultFieldRenderer, {
        rowItems: values,
        attrName: field,
        idPrefix: contextID ? `entityTable-${contextID}` : 'entityTable',
        scopeId: scopeId,
        render: showPreviewLink ? renderPreviewLink : renderField,
        "data-test-subj": "entity-table-value",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      });
    }
    if (render) {
      return render(data);
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}];
exports.getEntityTableColumns = getEntityTableColumns;