"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.policyFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _agent_status = require("../../../../common/components/endpoint/agents/agent_status");
var _empty_value = require("../../../../common/components/empty_value");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/host_right/fields/endpoint_policy_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const policyFields = exports.policyFields = [{
  label: i18n.ENDPOINT_POLICY,
  render: hostData => {
    var _hostData$details$end, _hostData$details$end2;
    const appliedPolicy = (_hostData$details$end = hostData.details.endpoint) === null || _hostData$details$end === void 0 ? void 0 : (_hostData$details$end2 = _hostData$details$end.hostInfo) === null || _hostData$details$end2 === void 0 ? void 0 : _hostData$details$end2.metadata.Endpoint.policy.applied;
    return appliedPolicy !== null && appliedPolicy !== void 0 && appliedPolicy.name ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, appliedPolicy.name) : (0, _empty_value.getEmptyTagValue)();
  },
  isVisible: hostData => hostData.details.endpoint != null
}, {
  label: i18n.POLICY_STATUS,
  render: hostData => {
    var _hostData$details$end3, _hostData$details$end4;
    const appliedPolicy = (_hostData$details$end3 = hostData.details.endpoint) === null || _hostData$details$end3 === void 0 ? void 0 : (_hostData$details$end4 = _hostData$details$end3.hostInfo) === null || _hostData$details$end4 === void 0 ? void 0 : _hostData$details$end4.metadata.Endpoint.policy.applied;
    const policyColor = (appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status) === _search_strategy.HostPolicyResponseActionStatus.failure ? 'danger' : appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status;
    return appliedPolicy !== null && appliedPolicy !== void 0 && appliedPolicy.status ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "aria-label": appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status,
      color: policyColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }, appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status) : (0, _empty_value.getEmptyTagValue)();
  },
  isVisible: hostData => hostData.details.endpoint != null
}, {
  label: i18n.SENSORVERSION,
  getValues: hostData => {
    var _hostData$details$end5, _hostData$details$end6, _hostData$details$end7, _hostData$details$end8;
    return (_hostData$details$end5 = hostData.details.endpoint) !== null && _hostData$details$end5 !== void 0 && (_hostData$details$end6 = _hostData$details$end5.hostInfo) !== null && _hostData$details$end6 !== void 0 && _hostData$details$end6.metadata.agent.version ? [(_hostData$details$end7 = hostData.details.endpoint) === null || _hostData$details$end7 === void 0 ? void 0 : (_hostData$details$end8 = _hostData$details$end7.hostInfo) === null || _hostData$details$end8 === void 0 ? void 0 : _hostData$details$end8.metadata.agent.version] : undefined;
  },
  field: 'agent.version',
  isVisible: hostData => hostData.details.endpoint != null
}, {
  label: i18n.FLEET_AGENT_STATUS,
  render: hostData => {
    var _hostData$details$end9, _hostData$details$end10;
    return (_hostData$details$end9 = hostData.details.endpoint) !== null && _hostData$details$end9 !== void 0 && _hostData$details$end9.hostInfo ? /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
      agentId: (_hostData$details$end10 = hostData.details.endpoint) === null || _hostData$details$end10 === void 0 ? void 0 : _hostData$details$end10.hostInfo.metadata.agent.id,
      agentType: "endpoint",
      "data-test-subj": "endpointHostAgentStatus",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }) : (0, _empty_value.getEmptyTagValue)();
  },
  isVisible: hostData => hostData.details.endpoint != null
}];