"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichmentAccordionGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _threat_details_view_enrichment_accordion = require("./threat_details_view_enrichment_accordion");
var _threat_intelligence = require("../../shared/utils/threat_intelligence");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/threat_details_view_enrichment_accordion_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Displays multiple accordions that each show the enrichment data
 */
const EnrichmentAccordionGroup = exports.EnrichmentAccordionGroup = /*#__PURE__*/(0, _react.memo)(({
  enrichments
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, enrichments.sort((a, b) => (0, _threat_intelligence.getFirstSeen)(b) - (0, _threat_intelligence.getFirstSeen)(a)).map((enrichment, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  key: `${enrichment.id}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_threat_details_view_enrichment_accordion.EnrichmentAccordion, {
  enrichment: enrichment,
  index: index,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 11
  }
}), index < enrichments.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 46
  }
})))));
EnrichmentAccordionGroup.displayName = 'EnrichmentAccordionGroup';