"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelContent = exports.IsolateHostPanelContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../shared/constants/panel_keys");
var _use_basic_data_from_details_data = require("../shared/hooks/use_basic_data_from_details_data");
var _host_isolation = require("../../../common/components/endpoint/host_isolation");
var _use_host_isolation = require("../shared/hooks/use_host_isolation");
var _context = require("./context");
var _flyout_body = require("../../shared/components/flyout_body");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/isolate_host/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Document details expandable flyout section content for the isolate host component, displaying the form or the success banner
 */
const PanelContent = () => {
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    dataFormattedForFieldBrowser,
    eventId,
    scopeId,
    indexName,
    isolateAction
  } = (0, _context.useIsolateHostPanelContext)();
  const {
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess
  } = (0, _use_host_isolation.useHostIsolation)();
  const {
    alertId,
    hostName
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const showAlertDetails = (0, _react.useCallback)(() => openRightPanel({
    id: _panel_keys.DocumentDetailsRightPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    }
  }), [eventId, indexName, scopeId, openRightPanel]);
  return /*#__PURE__*/_react.default.createElement(IsolateHostPanelContent, {
    isIsolateActionSuccessBannerVisible: isIsolateActionSuccessBannerVisible,
    hostName: hostName,
    alertId: alertId,
    isolateAction: isolateAction,
    dataFormattedForFieldBrowser: dataFormattedForFieldBrowser,
    showAlertDetails: showAlertDetails,
    handleIsolationActionSuccess: handleIsolationActionSuccess,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.PanelContent = PanelContent;
const IsolateHostPanelContent = ({
  isIsolateActionSuccessBannerVisible,
  hostName,
  alertId,
  isolateAction,
  dataFormattedForFieldBrowser,
  showAlertDetails,
  handleIsolationActionSuccess
}) => {
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    "data-test-subj": _test_ids.FLYOUT_HOST_ISOLATION_PANEL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, isIsolateActionSuccessBannerVisible && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
    hostName: hostName,
    alertId: alertId,
    isolateAction: isolateAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_host_isolation.HostIsolationPanel, {
    details: dataFormattedForFieldBrowser,
    cancelCallback: showAlertDetails,
    successCallback: handleIsolationActionSuccess,
    isolateAction: isolateAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};
exports.IsolateHostPanelContent = IsolateHostPanelContent;