"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setUsersPageQueriesActivePageToZero = exports.removeAssetTableField = exports.addAssetTableField = void 0;
var _model = require("./model");
var _constants = require("../../../common/store/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setUsersPageQueriesActivePageToZero = state => ({
  ...state.page.queries,
  [_model.UsersTableType.allUsers]: {
    ...state.page.queries[_model.UsersTableType.allUsers],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  }
});
exports.setUsersPageQueriesActivePageToZero = setUsersPageQueriesActivePageToZero;
const addAssetTableField = ({
  tableById,
  tableId,
  fieldName
}) => {
  const table = tableById[tableId];
  if (table.fields.includes(fieldName)) {
    // Do not add the field if it already exists
    return tableById;
  }
  return {
    ...tableById,
    [tableId]: {
      ...table,
      fields: [fieldName, ...table.fields]
    }
  };
};
exports.addAssetTableField = addAssetTableField;
const removeAssetTableField = ({
  tableId,
  fieldName,
  tableById
}) => {
  const table = tableById[tableId];
  const fields = table.fields.filter(c => c !== fieldName);
  return {
    ...tableById,
    [tableId]: {
      ...table,
      fields
    }
  };
};
exports.removeAssetTableField = removeAssetTableField;