"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _fp = require("lodash/fp");
var _helpers = require("../../../../common/lib/helpers");
var _redirect_to_network = require("../../../../common/components/link_to/redirect_to_network");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("./types");
var _types2 = require("../../../../app/types");
var _types3 = require("../navigation/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabNameMappedToI18nKey = {
  [_types.NetworkDetailsRouteType.events]: i18n.NAVIGATION_EVENTS_TITLE,
  [_types.NetworkDetailsRouteType.anomalies]: i18n.NAVIGATION_ANOMALIES_TITLE,
  [_types.NetworkDetailsRouteType.flows]: i18n.NAVIGATION_FLOWS_TITLE,
  [_types.NetworkDetailsRouteType.users]: i18n.NAVIGATION_USERS_TITLE,
  [_types.NetworkDetailsRouteType.http]: i18n.NAVIGATION_HTTP_TITLE,
  [_types.NetworkDetailsRouteType.tls]: i18n.NAVIGATION_TLS_TITLE,
  [_types3.NetworkRouteType.dns]: i18n.NAVIGATION_DNS_TITLE
};
/**
 * This module should only export this function.
 * All the `getTrailingBreadcrumbs` functions in Security are loaded into the main bundle.
 * We should be careful to not import unnecessary modules in this file to avoid increasing the main app bundle size.
 */
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  let breadcrumb = [];
  if (params.detailName != null) {
    breadcrumb = [{
      text: (0, _helpers.decodeIpv6)(params.detailName),
      href: getSecuritySolutionUrl({
        deepLinkId: _types2.SecurityPageName.network,
        path: (0, _redirect_to_network.getNetworkDetailsUrl)(params.detailName, params.flowTarget, '')
      })
    }];
  }
  const tabName = (0, _fp.get)('tabName', params);
  if (!tabName) return breadcrumb;
  breadcrumb = [...breadcrumb, {
    text: TabNameMappedToI18nKey[tabName],
    href: ''
  }];
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;