"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALID_UNTIL = exports.UNIT = exports.TRANSPORT_LAYER_SECURITY = exports.SUBJECT = exports.SHA1_FINGERPRINT = exports.ROWS_5 = exports.ROWS_10 = exports.JA3_FINGERPRINT = exports.ISSUER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSPORT_LAYER_SECURITY = exports.TRANSPORT_LAYER_SECURITY = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.transportLayerSecurityTitle', {
  defaultMessage: 'Transport Layer Security'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {server certificate} other {server certificates}}`
});

// Columns
exports.UNIT = UNIT;
const ISSUER = exports.ISSUER = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.columns.issuerTitle', {
  defaultMessage: 'Issuer'
});
const SUBJECT = exports.SUBJECT = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.columns.subjectTitle', {
  defaultMessage: 'Subject'
});
const SHA1_FINGERPRINT = exports.SHA1_FINGERPRINT = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.columns.sha1FingerPrintTitle', {
  defaultMessage: 'SHA1 fingerprint'
});
const JA3_FINGERPRINT = exports.JA3_FINGERPRINT = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.columns.ja3FingerPrintTitle', {
  defaultMessage: 'JA3 fingerprint'
});
const VALID_UNTIL = exports.VALID_UNTIL = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.columns.validUntilTitle', {
  defaultMessage: 'Valid until'
});

// Row Select
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.tlsTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});