"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkHttpTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_selector = require("../../../../common/hooks/use_selector");
var _paginated_table = require("../../../components/paginated_table");
var _columns = require("./columns");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/network_http_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const NetworkHttpTableComponent = ({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  showMorePagesIndicator,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getNetworkHttpSelector = (0, _react.useMemo)(() => _store.networkSelectors.httpSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getNetworkHttpSelector(state, type));
  const tableType = type === _store.networkModel.NetworkType.page ? _store.networkModel.NetworkTableType.http : _store.networkModel.NetworkDetailsTableType.http;
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      limit: newLimit
    }
  })), [dispatch, type, tableType]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      activePage: newPage
    }
  })), [dispatch, type, tableType]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null && criteria.sort.direction !== sort.direction) {
      dispatch(_store.networkActions.updateNetworkTable({
        networkType: type,
        tableType,
        updates: {
          sort: {
            direction: criteria.sort.direction
          }
        }
      }));
    }
  }, [sort.direction, dispatch, type, tableType]);
  const sorting = {
    field: `node.${_search_strategy.NetworkHttpFields.requestCount}`,
    direction: sort.direction
  };
  const columns = (0, _react.useMemo)(() => (0, _columns.getNetworkHttpColumns)(tableType), [tableType]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.HTTP_REQUESTS,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    itemsPerRow: rowItems,
    isInspect: isInspect,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    sorting: sorting,
    totalCount: fakeTotalCount,
    updateActivePage: updateActivePage,
    updateLimitPagination: updateLimitPagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
};
NetworkHttpTableComponent.displayName = 'NetworkHttpTableComponent';
const NetworkHttpTable = exports.NetworkHttpTable = /*#__PURE__*/_react.default.memo(NetworkHttpTableComponent);