"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _ = require("../app/404");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _constants = require("../../common/constants");
var _entity_analytics_management_page = require("./pages/entity_analytics_management_page");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _entity_store_management_page = require("./pages/entity_store_management_page");
var _entity_analytics_landing = require("./pages/entity_analytics_landing");
var _entity_analytics_privileged_user_monitoring_page = require("./pages/entity_analytics_privileged_user_monitoring_page");
var _entity_analytics_overview_page = require("./pages/entity_analytics_overview_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntityAnalyticsManagementWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_management_page.EntityAnalyticsManagementPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 5
  }
}));
const EntityAnalyticsManagementContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsManagementWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsManagementContainer.displayName = 'EntityAnalyticsManagementContainer';
const EntityAnalyticsAssetClassificationContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH,
    exact: true,
    render: ({
      location
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        ...location,
        pathname: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
        search: location.search
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsAssetClassificationContainer.displayName = 'EntityAnalyticsAssetClassificationContainer';
const EntityAnalyticsEntityStoreWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_store_management_page.EntityStoreManagementPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 5
  }
}));
const EntityAnalyticsEntityStoreContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsEntityStoreWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsEntityStoreContainer.displayName = 'EntityAnalyticsEntityStoreContainer';
const EntityAnalyticsLandingWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_landing.EntityAnalyticsLandingPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 5
  }
}));
const EntityAnalyticsLandingContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
    exact: true,
    component: EntityAnalyticsLandingWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsLandingContainer.displayName = 'EntityAnalyticsLandingContainer';
const EntityAnalyticsPrivilegedUserMonitoringWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 111,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_privileged_user_monitoring_page.EntityAnalyticsPrivilegedUserMonitoringPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 112,
    columnNumber: 5
  }
}));
const EntityAnalyticsPrivilegedUserMonitoringContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
    exact: true,
    component: EntityAnalyticsPrivilegedUserMonitoringWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsPrivilegedUserMonitoringContainer.displayName = 'EntityAnalyticsPrivilegedUserMonitoringContainer';
const EntityAnalyticsOverviewWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 133,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_overview_page.OverviewDashboard, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 134,
    columnNumber: 5
  }
}));
const EntityAnalyticsOverviewContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
    exact: true,
    component: EntityAnalyticsOverviewWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsOverviewContainer.displayName = 'EntityAnalyticsOverviewContainer';
const routes = exports.routes = [{
  path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsManagementContainer, _constants.SecurityPageName.entityAnalyticsManagement)
}, {
  path: _constants.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH,
  component: EntityAnalyticsAssetClassificationContainer
}, {
  path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsEntityStoreContainer, _constants.SecurityPageName.entityAnalyticsEntityStoreManagement)
}, {
  path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsLandingContainer, _constants.SecurityPageName.entityAnalyticsLanding)
}, {
  path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsPrivilegedUserMonitoringContainer, _constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring)
}, {
  path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsOverviewContainer, _constants.SecurityPageName.entityAnalyticsOverview)
}];