"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsManagementPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _risk_score_preview_section = require("../components/risk_score_management/risk_score_preview_section");
var _risk_score_enable_section = require("../components/risk_score_management/risk_score_enable_section");
var _translations = require("../../app/translations");
var _risk_engine_privileges_callout = require("../components/risk_engine_privileges_callout");
var _use_missing_risk_engine_privileges = require("../hooks/use_missing_risk_engine_privileges");
var _risk_score_useful_links_section = require("../components/risk_score_management/risk_score_useful_links_section");
var _risk_score_configuration_section = require("../components/risk_score_management/risk_score_configuration_section");
var _use_risk_engine_status = require("../api/hooks/use_risk_engine_status");
var _use_schedule_now_risk_engine_mutation = require("../api/hooks/use_schedule_now_risk_engine_mutation");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../translations"));
var _risk_score_page_styles = require("../components/risk_score_management/risk_score_page_styles");
var _risk_score_configurable_risk_engine_settings_hooks = require("../components/risk_score_management/hooks/risk_score_configurable_risk_engine_settings_hooks");
var _risk_score_save_bar = require("../components/risk_score_management/risk_score_save_bar");
var _risk_score_general_section = require("../components/risk_score_management/risk_score_general_section");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/pages/entity_analytics_management_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TEN_SECONDS = 10000;
const EntityAnalyticsManagementPage = () => {
  var _privileges$missingPr, _privileges$missingPr2, _privileges$missingPr3, _riskEngineStatus$ris;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _risk_score_page_styles.getEntityAnalyticsRiskScorePageStyles)(euiTheme);
  const privileges = (0, _use_missing_risk_engine_privileges.useMissingRiskEnginePrivileges)();
  const {
    savedRiskEngineSettings,
    selectedRiskEngineSettings,
    selectedSettingsMatchSavedSettings,
    resetSelectedSettings,
    saveSelectedSettingsMutation,
    setSelectedDateSetting,
    toggleSelectedClosedAlertsSetting,
    isLoadingRiskEngineSettings,
    toggleScoreRetainment
  } = (0, _risk_score_configurable_risk_engine_settings_hooks.useConfigurableRiskEngineSettings)();
  const {
    data: riskEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)({
    refetchInterval: TEN_SECONDS,
    structuralSharing: false // Force the component to rerender after every Risk Engine Status API call
  });
  const currentRiskEngineStatus = riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status;
  const runEngineEnabled = currentRiskEngineStatus === 'ENABLED';
  const [isLoadingRunRiskEngine, setIsLoadingRunRiskEngine] = (0, _react.useState)(false);
  const {
    mutate: scheduleNowRiskEngine
  } = (0, _use_schedule_now_risk_engine_mutation.useScheduleNowRiskEngineMutation)();
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const userCanRunEngine = !privileges.isLoading && (privileges.hasAllRequiredPrivileges || !privileges.hasAllRequiredPrivileges && ((_privileges$missingPr = privileges.missingPrivileges) === null || _privileges$missingPr === void 0 ? void 0 : (_privileges$missingPr2 = _privileges$missingPr.clusterPrivileges) === null || _privileges$missingPr2 === void 0 ? void 0 : (_privileges$missingPr3 = _privileges$missingPr2.run) === null || _privileges$missingPr3 === void 0 ? void 0 : _privileges$missingPr3.length) === 0) || false;
  const riskScoreResetToZeroIsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('enableRiskScoreResetToZero');
  const handleRunEngineClick = async () => {
    setIsLoadingRunRiskEngine(true);
    try {
      scheduleNowRiskEngine();
      if (!isLoadingRunRiskEngine) {
        addSuccess(i18n.RISK_SCORE_ENGINE_RUN_SUCCESS, {
          toastLifeTimeMs: 5000
        });
      }
    } catch (error) {
      addError(error, {
        title: i18n.RISK_SCORE_ENGINE_RUN_FAILURE
      });
    } finally {
      setIsLoadingRunRiskEngine(false);
    }
  };
  const {
    status,
    runAt
  } = (riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_task_status) || {};
  const isRunning = status === 'running' || !!runAt && new Date(runAt) < new Date();
  const runEngineBtnIsDisabled = !currentRiskEngineStatus || isLoadingRunRiskEngine || !userCanRunEngine || isRunning;
  const formatTimeFromNow = time => {
    if (!time) {
      return '';
    }
    return i18n.RISK_ENGINE_NEXT_RUN_TIME((0, _moment.default)(time).fromNow(true));
  };
  const countDownText = isRunning ? 'Now running' : formatTimeFromNow(riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : (_riskEngineStatus$ris = riskEngineStatus.risk_engine_task_status) === null || _riskEngineStatus$ris === void 0 ? void 0 : _riskEngineStatus$ris.runAt);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, {
    privileges: privileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "entityAnalyticsManagementPageTitle",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    }, _translations.ENTITY_ANALYTICS_RISK_SCORE), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'center',
      alignItems: "center",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 15
      }
    }, runEngineEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "play",
      disabled: runEngineBtnIsDisabled,
      isLoading: isLoadingRunRiskEngine,
      onClick: handleRunEngineClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 21
      }
    }, i18n.RUN_RISK_SCORE_ENGINE), /*#__PURE__*/_react.default.createElement(styles.VerticalSeparator, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 23
      }
    }, countDownText))), /*#__PURE__*/_react.default.createElement(_risk_score_enable_section.RiskScoreEnableSection, {
      selectedSettingsMatchSavedSettings: selectedSettingsMatchSavedSettings,
      saveSelectedSettingsMutation: saveSelectedSettingsMutation,
      privileges: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 17
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, !selectedRiskEngineSettings && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 41
    }
  }), selectedRiskEngineSettings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, riskScoreResetToZeroIsEnabled && /*#__PURE__*/_react.default.createElement(_risk_score_general_section.RiskScoreGeneralSection, {
    riskEngineSettings: selectedRiskEngineSettings,
    toggleScoreRetainment: toggleScoreRetainment,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_risk_score_configuration_section.RiskScoreConfigurationSection, {
    selectedRiskEngineSettings: selectedRiskEngineSettings,
    setSelectedDateSetting: setSelectedDateSetting,
    toggleSelectedClosedAlertsSetting: toggleSelectedClosedAlertsSetting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_risk_score_useful_links_section.RiskScoreUsefulLinksSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_score_preview_section.RiskScorePreviewSection, {
    privileges: privileges,
    includeClosedAlerts: selectedRiskEngineSettings.includeClosedAlerts,
    from: selectedRiskEngineSettings.range.start,
    to: selectedRiskEngineSettings.range.end,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  })))), savedRiskEngineSettings && !selectedSettingsMatchSavedSettings && /*#__PURE__*/_react.default.createElement(_risk_score_save_bar.RiskScoreSaveBar, {
    resetSelectedSettings: resetSelectedSettings,
    saveSelectedSettings: saveSelectedSettingsMutation.mutateAsync,
    isLoading: isLoadingRiskEngineSettings || saveSelectedSettingsMutation.isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }));
};
exports.EntityAnalyticsManagementPage = EntityAnalyticsManagementPage;
EntityAnalyticsManagementPage.displayName = 'EntityAnalyticsManagementPage';