"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityStoreErrorCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/entity_store_error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntityStoreErrorCallout = ({
  engine,
  size = 'm'
}) => {
  var _engine$error;
  if (!(engine !== null && engine !== void 0 && (_engine$error = engine.error) !== null && _engine$error !== void 0 && _engine$error.message)) {
    return null;
  }
  let title;
  // Please update the following code when adding a new action type
  switch (engine.error.action) {
    case 'init':
      title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.initError.title",
        defaultMessage: "An error occurred during {engineType} entity store resource initialization",
        values: {
          engineType: engine.type
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 9
        }
      });
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    color: "danger",
    iconType: "alert",
    size: size,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, engine.error.message));
};
exports.EntityStoreErrorCallout = EntityStoreErrorCallout;