"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCriticalityLevelColor = exports.AssetCriticalityBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/asset_criticality/asset_criticality_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Map Asset Criticality status to EUI severity color pattern as per spec:
 * https://eui.elastic.co/docs/patterns/severity/index.html#use-cases
 */
const getCriticalityLevelColor = (euiTheme, criticalityLevel) => {
  const {
    danger,
    risk,
    warning,
    neutral,
    unknown
  } = euiTheme.colors.severity;
  const map = {
    extreme_impact: danger,
    high_impact: risk,
    medium_impact: warning,
    low_impact: neutral,
    unassigned: unknown
  };
  return map[criticalityLevel] || map.unassigned;
};
exports.getCriticalityLevelColor = getCriticalityLevelColor;
const AssetCriticalityBadge = ({
  criticalityLevel = 'unassigned',
  style,
  dataTestSubj = 'asset-criticality-badge',
  className
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": dataTestSubj,
    color: getCriticalityLevelColor(euiTheme, criticalityLevel),
    css: style,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, _translations.CRITICALITY_LEVEL_TITLE[criticalityLevel]);
};
exports.AssetCriticalityBadge = AssetCriticalityBadge;