"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleNowRiskEngineMutation = exports.SCHEDULE_NOW_RISK_ENGINE_MUTATION_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../common/constants");
var _api = require("../api");
var _use_risk_engine_status = require("./use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULE_NOW_RISK_ENGINE_MUTATION_KEY = exports.SCHEDULE_NOW_RISK_ENGINE_MUTATION_KEY = ['POST', _constants.RISK_ENGINE_SCHEDULE_NOW_URL];
const useScheduleNowRiskEngineMutation = options => {
  const invalidateRiskEngineStatusQuery = (0, _use_risk_engine_status.useInvalidateRiskEngineStatusQuery)();
  const {
    scheduleNowRiskEngine
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useMutation)(() => scheduleNowRiskEngine(), {
    ...options,
    mutationKey: SCHEDULE_NOW_RISK_ENGINE_MUTATION_KEY,
    onSettled: (...args) => {
      invalidateRiskEngineStatusQuery();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useScheduleNowRiskEngineMutation = useScheduleNowRiskEngineMutation;