"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfigureSORiskEngineMutation = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConfigureSORiskEngineMutation = options => {
  const {
    updateSavedObjectConfiguration
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useMutation)(async params => {
    await updateSavedObjectConfiguration({
      exclude_alert_statuses: params.includeClosedAlerts ? [] : ['closed'],
      range: params.range,
      enable_reset_to_zero: params.enableResetToZero
    });
    return {
      risk_engine_saved_object_configured: true
    };
  }, options);
};
exports.useConfigureSORiskEngineMutation = useConfigureSORiskEngineMutation;