"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCalculateEntityRiskScore = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _engine_status_route = require("../../../../common/api/entity_analytics/risk_engine/engine_status_route.gen");
var _api = require("../api");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _use_risk_engine_status = require("./use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCalculateEntityRiskScore = (identifierType, identifier, {
  onSuccess
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data: riskEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const {
    calculateEntityRiskScore
  } = (0, _api.useEntityAnalyticsRoutes)();
  const onError = (0, _react.useCallback)(error => {
    addError(error, {
      title: _i18n.i18n.translate('xpack.securitySolution.entityDetails.userPanel.error', {
        defaultMessage: 'There was a problem calculating the {entity} risk score',
        values: {
          entity: `${identifierType}'s`
        }
      })
    });
  }, [addError, identifierType]);
  const {
    mutate,
    isLoading,
    data
  } = (0, _reactQuery.useMutation)(calculateEntityRiskScore, {
    onSuccess,
    onError
  });
  const calculateEntityRiskScoreCb = (0, _react.useCallback)(async () => {
    if ((riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status) === _engine_status_route.RiskEngineStatusEnum.ENABLED) {
      mutate({
        identifier_type: identifierType,
        identifier,
        refresh: 'wait_for'
      });
    }
  }, [riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status, mutate, identifierType, identifier]);
  return {
    isLoading,
    calculateEntityRiskScore: calculateEntityRiskScoreCb,
    data
  };
};
exports.useCalculateEntityRiskScore = useCalculateEntityRiskScore;