"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalFiltersAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utility_bar = require("../../../../common/components/utility_bar");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/additional_filters_action/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UtilityBarFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 175px;
`;
const AdditionalFiltersItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const BuildingBlockContainer = (0, _styledComponents.default)(AdditionalFiltersItem)`
  background: ${({
  theme
}) => theme.eui.euiColorHighlight};
`;
const CenterText = _styledComponents.default.span`
  text-align: center;
`;
const AdditionalFiltersAction = ({
  areEventsLoading,
  onShowBuildingBlockAlertsChanged,
  showBuildingBlockAlerts,
  onShowOnlyThreatIndicatorAlertsChanged,
  showOnlyThreatIndicatorAlerts
}) => {
  const UtilityBarAdditionalFiltersContent = (0, _react.useCallback)(closePopover => /*#__PURE__*/_react.default.createElement(UtilityBarFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(BuildingBlockContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "showBuildingBlockAlertsCheckbox",
    "aria-label": "showBuildingBlockAlerts",
    onChange: e => {
      closePopover();
      onShowBuildingBlockAlertsChanged(e.target.checked);
    },
    checked: showBuildingBlockAlerts,
    color: "text",
    "data-test-subj": "showBuildingBlockAlertsCheckbox",
    label: i18n.ADDITIONAL_FILTERS_ACTIONS_SHOW_BUILDING_BLOCK,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(AdditionalFiltersItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "showOnlyThreatIndicatorAlertsCheckbox",
    "aria-label": "showOnlyThreatIndicatorAlerts",
    onChange: e => {
      closePopover();
      onShowOnlyThreatIndicatorAlertsChanged(e.target.checked);
    },
    checked: showOnlyThreatIndicatorAlerts,
    color: "text",
    "data-test-subj": "showOnlyThreatIndicatorAlertsCheckbox",
    label: i18n.ADDITIONAL_FILTERS_ACTIONS_SHOW_ONLY_THREAT_INDICATOR_ALERTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }))), [onShowBuildingBlockAlertsChanged, onShowOnlyThreatIndicatorAlertsChanged, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts]);
  const additionalFilterCount = (showBuildingBlockAlerts ? 1 : 0) + (showOnlyThreatIndicatorAlerts ? 1 : 0);
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "additionalFilters",
    disabled: areEventsLoading,
    iconType: "arrowDown",
    iconSide: "right",
    ownFocus: true,
    popoverContent: UtilityBarAdditionalFiltersContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CenterText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, i18n.ADDITIONAL_FILTERS_ACTIONS, additionalFilterCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    "data-test-subj": "additionalFiltersCountBadge",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, `${additionalFilterCount}`))));
};
exports.AdditionalFiltersAction = AdditionalFiltersAction;