"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoIndexEmptyPage = exports.NO_INDEX_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _translations = require("./translations");
var _empty_page = require("../../../../common/components/empty_page");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/empty_pages/no_index_empty_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_INDEX_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.noIndexTitle', {
  defaultMessage: 'Let’s set up your detection engine'
});
const NEEDS_INDEX_PERMISSIONS = additionalContext => _i18n.i18n.translate('xpack.securitySolution.alertsPage.needsIndexPermissionsMessage', {
  values: {
    additionalContext
  },
  defaultMessage: 'To use the detection engine, a user with the required cluster and index privileges must first access this page. {additionalContext} For more help, contact your Elastic Stack administrator.'
});
const NEEDS_SIGNALS_AND_LISTS_INDEXES = _i18n.i18n.translate('xpack.securitySolution.alertsPage.needsSignalsAndListsIndexesMessage', {
  defaultMessage: 'You need permissions for the signals and lists indices.'
});
const NEEDS_SIGNALS_INDEX = _i18n.i18n.translate('xpack.securitySolution.alertsPage.needsSignalsIndexMessage', {
  defaultMessage: 'You need permissions for the signals index.'
});
const NEEDS_LISTS_INDEXES = _i18n.i18n.translate('xpack.securitySolution.alertsPage.needsListsIndexesMessage', {
  defaultMessage: 'You need permissions for the lists indices.'
});
const NO_INDEX_TEST_ID = exports.NO_INDEX_TEST_ID = 'alerts-page-no-index';
const buildMessage = (needsListsIndex, needsSignalsIndex) => {
  if (needsSignalsIndex && needsListsIndex) {
    return NEEDS_INDEX_PERMISSIONS(NEEDS_SIGNALS_AND_LISTS_INDEXES);
  } else if (needsSignalsIndex) {
    return NEEDS_INDEX_PERMISSIONS(NEEDS_SIGNALS_INDEX);
  } else if (needsListsIndex) {
    return NEEDS_INDEX_PERMISSIONS(NEEDS_LISTS_INDEXES);
  } else {
    return NEEDS_INDEX_PERMISSIONS('');
  }
};
/**
 * EmptyPage component rendered on the alerts page when the user does not have the required
 * permissions to view the signals index or lists indices.
 * It provides a link to the documentation for detections requirements.
 */
const NoIndexEmptyPage = exports.NoIndexEmptyPage = /*#__PURE__*/(0, _react.memo)(({
  needsListsIndex,
  needsSignalsIndex
}) => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const actions = (0, _react.useMemo)(() => ({
    detections: {
      icon: 'documents',
      label: _translations.GO_TO_DOCUMENTATION,
      url: `${docLinks.links.siem.detectionsReq}`,
      target: '_blank'
    }
  }), [docLinks]);
  const message = buildMessage(needsListsIndex, needsSignalsIndex);
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: actions,
    "data-test-subj": NO_INDEX_TEST_ID,
    message: message,
    title: NO_INDEX_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  });
});
NoIndexEmptyPage.displayName = 'NoIndexEmtpyPage';