"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columns = exports.Table = exports.TOOLBAR_VISIBILITY = exports.TIMESTAMP_COLUMN = exports.SEVERITY_COLUMN = exports.RULE_TYPE_IDS = exports.RULE_NAME_COLUMN = exports.ROW_HEIGHTS_OPTIONS = exports.RELATED_INTEGRATION_COLUMN = exports.GRID_STYLE = exports.EuiDataGridStyleWrapper = exports.CASES_CONFIGURATION = exports.ALERT_TABLE_CONSUMERS = exports.ACTION_COLUMN_WIDTH = void 0;
var _react = _interopRequireWildcard(require("react"));
var _dataService = require("@kbn/data-service");
var _i18n = require("@kbn/i18n");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _constants = require("../../../constants");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _constants2 = require("../../../../data_view_manager/constants");
var _use_additional_bulk_actions = require("../../../hooks/alert_summary/use_additional_bulk_actions");
var _common = require("../../../../../common");
var _actions_cell = require("./actions_cell");
var _additional_toolbar_controls = require("./additional_toolbar_controls");
var _store = require("../../../../common/store");
var _use_selector = require("../../../../common/hooks/use_selector");
var _kuery = require("../../../../common/lib/kuery");
var _kibana = require("../../../../common/lib/kibana");
var _render_cell = require("./render_cell");
var _helpers = require("../../alerts_table/helpers");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TIMESTAMP_COLUMN = exports.TIMESTAMP_COLUMN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.table.column.timeStamp', {
  defaultMessage: 'Timestamp'
});
const RELATED_INTEGRATION_COLUMN = exports.RELATED_INTEGRATION_COLUMN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.table.column.relatedIntegrationName', {
  defaultMessage: 'Integration'
});
const SEVERITY_COLUMN = exports.SEVERITY_COLUMN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.table.column.severity', {
  defaultMessage: 'Severity'
});
const RULE_NAME_COLUMN = exports.RULE_NAME_COLUMN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.table.column.ruleName', {
  defaultMessage: 'Rule'
});
const columns = exports.columns = [{
  id: _ruleDataUtils.TIMESTAMP,
  displayAsText: TIMESTAMP_COLUMN
}, {
  id: _constants.RELATED_INTEGRATION,
  displayAsText: RELATED_INTEGRATION_COLUMN
}, {
  id: _ruleDataUtils.ALERT_SEVERITY,
  displayAsText: SEVERITY_COLUMN
}, {
  id: _ruleDataUtils.ALERT_RULE_NAME,
  displayAsText: RULE_NAME_COLUMN
}];
const ACTION_COLUMN_WIDTH = exports.ACTION_COLUMN_WIDTH = 72; // px
const ALERT_TABLE_CONSUMERS = exports.ALERT_TABLE_CONSUMERS = [_ruleDataUtils.AlertConsumers.SIEM];
const RULE_TYPE_IDS = exports.RULE_TYPE_IDS = [_securitysolutionRules.ESQL_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID];
const ROW_HEIGHTS_OPTIONS = exports.ROW_HEIGHTS_OPTIONS = {
  defaultHeight: 40
};
const TOOLBAR_VISIBILITY = exports.TOOLBAR_VISIBILITY = {
  showDisplaySelector: false,
  showKeyboardShortcuts: false,
  showFullScreenSelector: false
};
const GRID_STYLE = exports.GRID_STYLE = {
  border: 'horizontal'
};
const CASES_CONFIGURATION = exports.CASES_CONFIGURATION = {
  featureId: _common.CASES_FEATURE_ID,
  owner: [_common.APP_ID],
  syncAlerts: true,
  extractObservables: true
};

// This will guarantee that ALL cells will have their values vertically centered.
// While these styles were originally applied in the RenderCell component, they were not applied to the bulk action checkboxes.
// These are necessary because the ResponseOps alerts table is not centering values vertically, which is visible when using a custom row height.
const EuiDataGridStyleWrapper = exports.EuiDataGridStyleWrapper = _styled.default.div`
  div .euiDataGridRowCell__content {
    align-items: center;
    display: flex;
    height: 100%;
  }
`;
/**
 * Renders the table showing all the alerts. This component leverages the ResponseOps AlertsTable in a similar way that the alerts page does.
 * The table is used in combination with the GroupedAlertsTable component.
 */
const Table = exports.Table = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  groupingFilters,
  packages
}) => {
  const {
    services: {
      application,
      cases,
      data,
      fieldFormats,
      http,
      licensing,
      notifications,
      uiSettings,
      settings
    }
  } = (0, _kibana.useKibana)();
  const services = (0, _react.useMemo)(() => ({
    cases,
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  }), [application, cases, data, fieldFormats, http, licensing, notifications, settings]);
  const getGlobalFiltersSelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersSelector);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const timeRangeFilter = (0, _react.useMemo)(() => (0, _helpers.buildTimeRangeFilter)(from, to), [from, to]);
  const filters = (0, _react.useMemo)(() => [...globalFilters, ...timeRangeFilter, ...groupingFilters.filter(filter => filter.meta.type !== 'custom')], [globalFilters, groupingFilters, timeRangeFilter]);
  const dataViewSpec = (0, _react.useMemo)(() => dataView.toSpec(), [dataView]);
  const browserFields = (0, _use_browser_fields.useBrowserFields)(_constants2.DataViewManagerScopeName.detections, dataView);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const globalQuery = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const query = (0, _react.useMemo)(() => {
    const combinedQuery = (0, _kuery.combineQueries)({
      config: (0, _dataService.getEsQueryConfig)(uiSettings),
      dataProviders: [],
      dataViewSpec,
      dataView,
      browserFields,
      filters,
      kqlQuery: globalQuery,
      kqlMode: globalQuery.language
    });
    if (combinedQuery !== null && combinedQuery !== void 0 && combinedQuery.kqlError || !(combinedQuery !== null && combinedQuery !== void 0 && combinedQuery.filterQuery)) {
      return {
        bool: {}
      };
    }
    try {
      const filter = JSON.parse(combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery);
      return {
        bool: {
          filter
        }
      };
    } catch {
      return {
        bool: {}
      };
    }
  }, [browserFields, dataView, dataViewSpec, filters, globalQuery, uiSettings]);
  const renderAdditionalToolbarControls = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_additional_toolbar_controls.AdditionalToolbarControls, {
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }), [dataView]);
  const additionalContext = (0, _react.useMemo)(() => ({
    packages
  }), [packages]);
  const refetchRef = (0, _react.useRef)(null);
  const refetch = (0, _react.useCallback)(() => {
    var _refetchRef$current;
    (_refetchRef$current = refetchRef.current) === null || _refetchRef$current === void 0 ? void 0 : _refetchRef$current.refresh();
  }, []);
  const bulkActions = (0, _use_additional_bulk_actions.useAdditionalBulkActions)({
    refetch
  });
  const runtimeMappings = (0, _react.useMemo)(() => dataView.getRuntimeMappings(), [dataView]);
  return /*#__PURE__*/_react.default.createElement(EuiDataGridStyleWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, {
    actionsColumnWidth: ACTION_COLUMN_WIDTH,
    additionalBulkActions: bulkActions,
    additionalContext: additionalContext,
    browserFields: browserFields,
    casesConfiguration: CASES_CONFIGURATION,
    columns: columns,
    consumers: ALERT_TABLE_CONSUMERS,
    gridStyle: GRID_STYLE,
    id: _securitysolutionDataTable.TableId.alertsOnAlertSummaryPage,
    query: query,
    ref: refetchRef,
    renderActionsCell: _actions_cell.ActionsCell,
    renderAdditionalToolbarControls: renderAdditionalToolbarControls,
    renderCellValue: _render_cell.CellValue,
    rowHeightsOptions: ROW_HEIGHTS_OPTIONS,
    runtimeMappings: runtimeMappings,
    ruleTypeIds: RULE_TYPE_IDS,
    services: services,
    toolbarVisibility: TOOLBAR_VISIBILITY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }));
});
Table.displayName = 'Table';