"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionEventsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _header_section = require("../../../../common/components/header_section");
var _event_type_filter = require("../basic/filters/event_type_filter");
var _log_level_filter = require("../basic/filters/log_level_filter");
var _execution_events_table_row_details = require("./execution_events_table_row_details");
var _use_filters = require("./use_filters");
var _use_sorting = require("../basic/tables/use_sorting");
var _use_pagination = require("../basic/tables/use_pagination");
var _use_columns = require("./use_columns");
var _use_expandable_rows = require("../basic/tables/use_expandable_rows");
var _use_execution_events = require("./use_execution_events");
var _event_message_filter = require("./event_message_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_monitoring/components/execution_events_table/execution_events_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE_OPTIONS = [10, 20, 50, 100, 200];
const ExecutionEventsTableComponent = ({
  ruleId
}) => {
  const getItemId = (0, _react.useCallback)(item => {
    return `${item.timestamp} ${item.sequence}`;
  }, []);
  const renderExpandedItem = (0, _react.useCallback)(item => {
    return /*#__PURE__*/_react.default.createElement(_execution_events_table_row_details.ExecutionEventsTableRowDetails, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  }, []);
  const rows = (0, _use_expandable_rows.useExpandableRows)({
    getItemId,
    renderItem: renderExpandedItem
  });
  const columns = (0, _use_columns.useColumns)({
    toggleRowExpanded: rows.toggleRowExpanded,
    isRowExpanded: rows.isRowExpanded
  });
  const filters = (0, _use_filters.useFilters)();
  const sorting = (0, _use_sorting.useSorting)('timestamp', 'desc');
  const pagination = (0, _use_pagination.usePagination)({
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const executionEvents = (0, _use_execution_events.useExecutionEvents)({
    ruleId,
    searchTerm: filters.state.searchTerm,
    eventTypes: filters.state.eventTypes,
    logLevels: filters.state.logLevels,
    dateRange: filters.state.dateRange,
    sortOrder: sorting.state.sort.direction,
    page: pagination.state.pageNumber,
    perPage: pagination.state.pageSize
  });

  // Each time execution events are fetched
  (0, _react.useEffect)(() => {
    var _executionEvents$data;
    // We need to update total item count for the pagination to work properly
    pagination.updateTotalItemCount((_executionEvents$data = executionEvents.data) === null || _executionEvents$data === void 0 ? void 0 : _executionEvents$data.pagination.total);
  }, [executionEvents, pagination]);
  const items = (0, _react.useMemo)(() => {
    var _executionEvents$data2, _executionEvents$data3;
    return (_executionEvents$data2 = (_executionEvents$data3 = executionEvents.data) === null || _executionEvents$data3 === void 0 ? void 0 : _executionEvents$data3.events) !== null && _executionEvents$data2 !== void 0 ? _executionEvents$data2 : [];
  }, [executionEvents.data]);
  const handleTableChange = (0, _react.useCallback)(criteria => {
    sorting.update(criteria);
    pagination.update(criteria);
  }, [sorting, pagination]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.TABLE_TITLE,
    subtitle: i18n.TABLE_SUBTITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_event_message_filter.EventMessageFilter, {
    value: filters.state.searchTerm,
    onChange: filters.setSearchTerm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_log_level_filter.LogLevelFilter, {
    selectedItems: filters.state.logLevels,
    onChange: filters.setLogLevels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_event_type_filter.EventTypeFilter, {
    selectedItems: filters.state.eventTypes,
    onChange: filters.setEventTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: filters.state.dateRange.start,
    end: filters.state.dateRange.end,
    onTimeChange: filters.setDateRange,
    showUpdateButton: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: items,
    itemId: getItemId,
    itemIdToExpandedRowMap: rows.itemIdToExpandedRowMap,
    loading: executionEvents.isFetching,
    sorting: sorting.state,
    pagination: pagination.state,
    onChange: handleTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }));
};
const ExecutionEventsTable = exports.ExecutionEventsTable = /*#__PURE__*/_react.default.memo(ExecutionEventsTableComponent);
ExecutionEventsTable.displayName = 'RuleExecutionEventsTable';