"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionRunTypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _multiselect_filter = require("../multiselect_filter");
var _rule_monitoring = require("../../../../../../../common/api/detection_engine/rule_monitoring");
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../../../../../common/translations");
var _kibana = require("../../../../../../common/lib/kibana");
var _telemetry = require("../../../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_monitoring/components/basic/filters/execution_run_type_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExecutionRunTypeFilterComponent = ({
  items,
  selectedItems,
  onChange
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const renderItem = (0, _react.useCallback)(item => {
    if (item === _rule_monitoring.RuleRunTypeEnum.backfill) {
      return _translations2.RULE_EXECUTION_TYPE_BACKFILL;
    } else if (item === _rule_monitoring.RuleRunTypeEnum.standard) {
      return _translations2.RULE_EXECUTION_TYPE_STANDARD;
    } else {
      return '-';
    }
  }, []);
  const handleSelectionChange = (0, _react.useCallback)(types => {
    onChange(types);
    telemetry.reportEvent(_telemetry.EventLogEventTypes.EventLogFilterByRunType, {
      runType: types
    });
  }, [onChange, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    dataTestSubj: "ExecutionRunTypeFilter",
    title: i18n.FILTER_TITLE,
    items: items,
    selectedItems: selectedItems,
    onSelectionChange: handleSelectionChange,
    renderItem: renderItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  });
};
const ExecutionRunTypeFilter = exports.ExecutionRunTypeFilter = /*#__PURE__*/_react.default.memo(ExecutionRunTypeFilterComponent);
ExecutionRunTypeFilter.displayName = 'ExecutionRunTypeFilter';