"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulePreviewFlyout = useRulePreviewFlyout;
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../common/utils/invariant");
var _rule_details_flyout = require("../../../rule_management/components/rule_details/rule_details_flyout");
var _rule_preview_context = require("./upgrade_prebuilt_rules_table/rule_preview_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/use_rule_preview_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useRulePreviewFlyout({
  rules,
  extraTabsFactory,
  ruleActionsFactory,
  subHeaderFactory,
  flyoutProps,
  closeRulePreviewAction
}) {
  const [rule, setRuleForPreview] = (0, _react.useState)();
  const closeRulePreview = (0, _react.useCallback)(reason => {
    if (closeRulePreviewAction && rule) {
      closeRulePreviewAction(rule, reason);
    }
    setRuleForPreview(undefined);
  }, [closeRulePreviewAction, rule]);
  const openRulePreview = (0, _react.useCallback)(ruleId => {
    const ruleToShowInFlyout = rules.find(x => x.rule_id === ruleId);
    (0, _invariant.invariant)(ruleToShowInFlyout, `Rule with rule_id ${ruleId} not found`);
    setRuleForPreview(ruleToShowInFlyout);
  }, [rules, setRuleForPreview]);
  const rulePreviewFlyout = /*#__PURE__*/_react.default.createElement(_rule_preview_context.RulePreviewContextProvider, {
    ruleId: rule === null || rule === void 0 ? void 0 : rule.rule_id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(RulePreviewFlyoutInternal, {
    rule: rule,
    closeRulePreview: closeRulePreview,
    extraTabsFactory: extraTabsFactory,
    ruleActionsFactory: ruleActionsFactory,
    subHeaderFactory: subHeaderFactory,
    flyoutProps: flyoutProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
  return {
    rulePreviewFlyout,
    openRulePreview,
    closeRulePreview
  };
}
const RulePreviewFlyoutInternal = /*#__PURE__*/(0, _react.memo)(function RulePreviewFlyoutInternal({
  rule,
  closeRulePreview,
  extraTabsFactory,
  ruleActionsFactory,
  subHeaderFactory,
  flyoutProps
}) {
  const {
    isEditingRule
  } = (0, _rule_preview_context.useRulePreviewContext)();
  const ruleActions = (0, _react.useMemo)(() => rule && ruleActionsFactory(rule, () => closeRulePreview('call_to_action'), isEditingRule), [rule, ruleActionsFactory, closeRulePreview, isEditingRule]);
  const extraTabs = (0, _react.useMemo)(() => rule && extraTabsFactory ? extraTabsFactory(rule) : [], [rule, extraTabsFactory]);
  const subHeader = (0, _react.useMemo)(() => rule ? subHeaderFactory === null || subHeaderFactory === void 0 ? void 0 : subHeaderFactory(rule) : null, [subHeaderFactory, rule]);
  if (!rule) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_rule_details_flyout.RuleDetailsFlyout, {
    rule: rule,
    size: "l",
    id: flyoutProps.id,
    dataTestSubj: flyoutProps.dataTestSubj,
    closeFlyout: () => closeRulePreview('dismiss'),
    ruleActions: ruleActions,
    extraTabs: extraTabs,
    subHeader: subHeader,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  });
});