"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesTableFilters = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _tags_filter_popover = require("../rules_table_filters/tags_filter_popover");
var _rule_search_field = require("../rules_table_filters/rule_search_field");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilterWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeM};
`;

/**
 * Collection of filters for filtering data within the Add Prebuilt Rules table.
 * Contains search bar and tag selection
 */
const AddPrebuiltRulesTableFiltersComponent = () => {
  const {
    state: {
      filterOptions,
      tags
    },
    actions: {
      setFilterOptions
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const {
    tags: selectedTags
  } = filterOptions;
  const handleOnSearch = (0, _react.useCallback)(filterString => {
    setFilterOptions(filters => ({
      ...filters,
      filter: filterString.trim()
    }));
  }, [setFilterOptions]);
  const handleSelectedTags = (0, _react.useCallback)(newTags => {
    if (!(0, _fp.isEqual)(newTags, selectedTags)) {
      setFilterOptions(filters => ({
        ...filters,
        tags: newTags
      }));
    }
  }, [selectedTags, setFilterOptions]);
  return /*#__PURE__*/_react.default.createElement(FilterWrapper, {
    gutterSize: "m",
    justifyContent: "flexEnd",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_search_field.RuleSearchField, {
    initialValue: filterOptions.filter,
    onSearch: handleOnSearch,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tags_filter_popover.TagsFilterPopover, {
    onSelectedTagsChanged: handleSelectedTags,
    selectedTags: selectedTags,
    tags: tags,
    "data-test-subj": "allRulesTagPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }))));
};
AddPrebuiltRulesTableFiltersComponent.displayName = 'AddPrebuiltRulesTableFiltersComponent';
const AddPrebuiltRulesTableFilters = exports.AddPrebuiltRulesTableFilters = /*#__PURE__*/_react.default.memo(AddPrebuiltRulesTableFiltersComponent);
AddPrebuiltRulesTableFilters.displayName = 'AddPrebuiltRulesTableFilters';